/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile.dispense;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityCannonBall;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DispenseCannonBall
extends DefaultDispenseItemBehavior {
    private final Random rand = new Random();
    private boolean normalDispense = false;

    @NotNull
    public ItemStack execute(BlockSource blocksource, @NotNull ItemStack itemstack) {
        boolean canFire = false;
        this.normalDispense = false;
        BlockEntity blockEntity = blocksource.level().getBlockEntity(blocksource.pos());
        if (blockEntity instanceof DispenserBlockEntity) {
            DispenserBlockEntity dispenser = (DispenserBlockEntity)blockEntity;
            Item itemToCheck = null;
            if (itemstack.getItem() == Items.GUNPOWDER) {
                itemToCheck = (Item)WMRegistries.ITEM_CANNON_BALL.get();
            } else if (itemstack.getItem() == WMRegistries.ITEM_CANNON_BALL.get()) {
                itemToCheck = Items.GUNPOWDER;
            }
            for (int i = 0; i < dispenser.getContainerSize(); ++i) {
                ItemStack itemStack2 = dispenser.getItem(i);
                if (itemStack2.isEmpty() || itemStack2.getItem() != itemToCheck) continue;
                dispenser.removeItem(i, 1);
                canFire = true;
                break;
            }
        }
        if (!canFire) {
            this.normalDispense = true;
            return super.execute(blocksource, itemstack);
        }
        Direction face = (Direction)blocksource.state().getValue((Property)DispenserBlock.FACING);
        double xVel = (double)face.getStepX() * 1.5;
        double yVel = (double)face.getStepY() * 1.5;
        double zVel = (double)face.getStepZ() * 1.5;
        Position pos = DispenserBlock.getDispensePosition((BlockSource)blocksource);
        EntityCannonBall entitycannonball = new EntityCannonBall((Level)blocksource.level(), pos.x() + xVel, pos.y() + yVel, pos.z() + zVel, null);
        entitycannonball.shoot(xVel, yVel + 0.15, zVel, 2.0f, 2.0f);
        blocksource.level().addFreshEntity((Entity)entitycannonball);
        itemstack.shrink(1);
        return itemstack;
    }

    protected void playSound(@NotNull BlockSource blocksource) {
        if (this.normalDispense) {
            super.playSound(blocksource);
            return;
        }
        blocksource.level().playSound(null, blocksource.pos(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 8.0f, 1.0f / (this.rand.nextFloat() * 0.8f + 0.9f));
        blocksource.level().playSound(null, blocksource.pos(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.NEUTRAL, 8.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.6f));
    }

    protected void playAnimation(@NotNull BlockSource blocksource, @NotNull Direction face) {
        super.playAnimation(blocksource, face);
        if (!this.normalDispense) {
            Position pos = DispenserBlock.getDispensePosition((BlockSource)blocksource);
            if (blocksource.level().isClientSide()) {
                blocksource.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x() + (double)face.getStepX(), pos.y() + (double)face.getStepY(), pos.z() + (double)face.getStepZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

