/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile.dispense;

import ckathode.weaponmod.entity.projectile.dispense.WMDispenserExtension;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DispenseWeaponProjectile
extends ProjectileDispenseBehavior {
    @NotNull
    private final WMDispenserExtension extension;

    public DispenseWeaponProjectile(@NotNull Item projectile, @NotNull WMDispenserExtension extension) {
        super(projectile);
        this.extension = extension;
    }

    @NotNull
    public ItemStack execute(@NotNull BlockSource blockSource, @NotNull ItemStack item) {
        ServerLevel level = blockSource.level();
        Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
        Position position = this.dispenseConfig.positionFunction().getDispensePosition(blockSource, direction);
        Projectile projectile = this.projectileItem.asProjectile((Level)level, position, item, direction);
        this.projectileItem.shoot(projectile, (double)direction.getStepX(), (double)direction.getStepY() + this.getYVel(blockSource, item), (double)direction.getStepZ(), this.dispenseConfig.power(), this.dispenseConfig.uncertainty());
        level.addFreshEntity((Entity)projectile);
        item.shrink(1);
        return item;
    }

    public double getYVel(@NotNull BlockSource blockSource, @NotNull ItemStack item) {
        return this.extension.getYVel((bs, i) -> 0.1, blockSource, item);
    }

    public void playSound(@NotNull BlockSource blockSource) {
        this.extension.playSound(x$0 -> super.playSound(x$0), blockSource);
    }

    public void playAnimation(@NotNull BlockSource blockSource, @NotNull Direction direction) {
        this.extension.playAnimation((x$0, x$1) -> super.playAnimation(x$0, x$1), blockSource, direction);
    }
}

