/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_10774;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDynamite
extends EntityProjectile<EntityDynamite> {
    public static final String ID = "dynamite";
    public static final class_1299<EntityDynamite> TYPE = WMRegistries.createEntityType("dynamite", class_4048.method_18385((float)0.5f, (float)0.5f).method_55685(0.0f), EntityDynamite::new);
    private int explodefuse;
    private boolean extinguished;

    public EntityDynamite(class_1299<EntityDynamite> entityType, class_1937 world) {
        super(entityType, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        this.extinguished = false;
        this.explodefuse = this.field_5974.method_43048(30) + 20;
    }

    public EntityDynamite(class_1937 world, double d, double d1, double d2, @Nullable class_1799 firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        this.extinguished = false;
        this.explodefuse = this.field_5974.method_43048(30) + 20;
        this.method_5814(d, d1, d2);
    }

    public EntityDynamite(class_1937 world, class_1309 shooter, int i, @Nullable class_1799 firedFromWeapon) {
        this(world, shooter.method_23317(), shooter.method_23320() - 0.1, shooter.method_23321(), firedFromWeapon);
        this.method_7432((class_1297)shooter);
        this.explodefuse = i;
    }

    @NotNull
    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return NetworkManager.createAddEntityPacket((class_1297)this, (class_3231)serverEntity);
    }

    public void method_24919(class_1297 entity, float f, float f1, float f2, float f3, float f4) {
        float x = -class_3532.method_15374((float)(f1 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
        float y = -class_3532.method_15374((float)(f * ((float)Math.PI / 180)));
        float z = class_3532.method_15362((float)(f1 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
        this.method_7485(x, y, z, f3, f4);
        class_243 entityMotion = entity.method_18798();
        this.method_18799(this.method_18798().method_1031(entityMotion.field_1352, entity.method_24828() ? 0.0 : entityMotion.field_1351, entityMotion.field_1350));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.inGround && !this.beenInGround) {
            this.field_5965 -= 50.0f;
            if (this.field_5965 <= -360.0f) {
                this.field_5965 += 360.0f;
            }
        } else {
            this.field_5965 = this.field_6004 = 180.0f;
        }
        if (this.method_5799() && !this.extinguished) {
            this.extinguished = true;
            this.method_5783(class_3417.field_15222, 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
            for (int k = 0; k < 8; ++k) {
                float f6 = 0.25f;
                class_243 motion = this.method_18798();
                class_243 pos = this.method_19538().method_1020(motion.method_1021((double)f6));
                if (!this.method_37908().method_8608()) continue;
                this.method_37908().method_8406((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
            }
        }
        --this.explodefuse;
        if (!this.extinguished) {
            if (this.explodefuse <= 0) {
                this.detonate();
                this.method_5650(class_1297.class_5529.field_26999);
            } else if (this.method_37908().method_8608()) {
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    @NotNull
    public class_1282 getDamageSource() {
        return this.method_48923().method_48797(WMDamageSources.WEAPON, (class_1297)this, this.getDamagingEntity());
    }

    @Override
    public void method_7454(class_3966 result) {
        class_1297 entity = result.method_17782();
        if (entity.method_64420(this.getDamageSource(), 1.0f)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.method_5750(0.0, 0.0, 0.0);
            this.ticksInAir = 0;
        }
    }

    @Override
    public void method_24920(class_3965 result) {
        class_2338 blockpos = result.method_17777();
        this.xTile = blockpos.method_10263();
        this.yTile = blockpos.method_10264();
        this.zTile = blockpos.method_10260();
        this.inBlockState = this.method_37908().method_8320(blockpos);
        class_243 motion = result.method_17784().method_1020(this.method_19538());
        this.method_18799(motion);
        class_243 newPos = this.method_19538().method_1020(motion.method_1029().method_1021(0.05));
        this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        this.method_18800(-0.2 * motion.field_1352, motion.field_1351, -0.2 * motion.field_1350);
        if (result.method_17780() == class_2350.field_11036) {
            this.inGround = true;
            this.beenInGround = true;
        } else {
            this.inGround = false;
            this.method_5783(class_3417.field_15222, 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        }
        if (this.inBlockState != null) {
            this.inBlockState.method_26178(this.method_37908(), blockpos, (class_1297)this, class_10774.field_56634);
        }
    }

    private void detonate() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (this.extinguished && (this.ticksInGround >= 200 || this.ticksInAir >= 200)) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        float f = 2.0f;
        PhysHelper.createAdvancedExplosion(serverLevel, (class_1297)this, this.method_19538(), f, WeaponModConfig.get().dynamiteDoesBlockDamage, true, false, class_1927.class_4179.field_18687);
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @NotNull
    protected class_1799 method_7445() {
        return this.method_57314();
    }

    @Override
    @NotNull
    protected class_1799 method_57314() {
        return new class_1799((class_1935)WMRegistries.ITEM_DYNAMITE.get());
    }

    @Override
    public void playHitSound() {
        this.method_5783(class_3417.field_15222, 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
    }

    @Override
    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71462("fuse", (byte)this.explodefuse);
        valueOutput.method_71472("off", this.extinguished);
    }

    @Override
    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.explodefuse = valueInput.method_71421("fuse", (byte)50);
        this.extinguished = valueInput.method_71433("off", false);
    }
}

