/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WarhammerExplosion;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_9424;
import net.minecraft.class_9886;
import org.jetbrains.annotations.NotNull;

public class MeleeCompWarhammer
extends MeleeComponent {
    public static final int CHARGE_DELAY = 400;
    public static final String WOOD_ID = "warhammer.wood";
    public static final ItemMelee WOOD_ITEM = WMItemBuilder.createStandardWarhammer(class_9886.field_52585, BalkonsWeaponMod.id("warhammer.wood"));
    public static final String STONE_ID = "warhammer.stone";
    public static final ItemMelee STONE_ITEM = WMItemBuilder.createStandardWarhammer(class_9886.field_52586, BalkonsWeaponMod.id("warhammer.stone"));
    public static final String IRON_ID = "warhammer.iron";
    public static final ItemMelee IRON_ITEM = WMItemBuilder.createStandardWarhammer(class_9886.field_52587, BalkonsWeaponMod.id("warhammer.iron"));
    public static final String GOLD_ID = "warhammer.gold";
    public static final ItemMelee GOLD_ITEM = WMItemBuilder.createStandardWarhammer(class_9886.field_52589, BalkonsWeaponMod.id("warhammer.gold"));
    public static final String DIAMOND_ID = "warhammer.diamond";
    public static final ItemMelee DIAMOND_ITEM = WMItemBuilder.createStandardWarhammer(class_9886.field_52588, BalkonsWeaponMod.id("warhammer.diamond"));
    public static final String NETHERITE_ID = "warhammer.netherite";
    public static final ItemMelee NETHERITE_ITEM = WMItemBuilder.createStandardWarhammer(class_9886.field_52590, BalkonsWeaponMod.id("warhammer.netherite"));

    public MeleeCompWarhammer(class_9886 itemTier) {
        super(MeleeComponent.MeleeSpecs.WARHAMMER, itemTier);
    }

    @Override
    @NotNull
    public class_9424 getToolComponent() {
        class_9424 orig = super.getToolComponent();
        return new class_9424(orig.comp_2498(), orig.comp_2499() * (this.weaponMaterial.comp_2933() + 2.0f), 1, false);
    }

    @Override
    public boolean releaseUsing(class_1799 itemstack, class_1937 world, class_1309 entityliving, int i) {
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 4.0f) > 1.0f) {
            this.superSmash(itemstack, world, entityliving);
        }
        return true;
    }

    protected void superSmash(class_1799 itemstack, class_1937 world, class_1309 entityLiving) {
        entityLiving.method_6104(class_1268.field_5808);
        float f = this.getEntityDamage() / 2.0f;
        if (world instanceof class_3218) {
            class_1282 class_12822;
            class_3218 serverLevel = (class_3218)world;
            WarhammerExplosion expl = new WarhammerExplosion(serverLevel, (class_1297)entityLiving, entityLiving.method_19538(), f, false, class_1927.class_4179.field_18687);
            if (entityLiving instanceof class_1657) {
                class_1657 player = (class_1657)entityLiving;
                class_12822 = world.method_48963().method_48802(player);
            } else {
                class_12822 = world.method_48963().method_48812(entityLiving);
            }
            class_1282 source = class_12822;
            expl.doEntityExplosion(source);
            expl.doParticleExplosion(true, false);
            PhysHelper.sendExplosion(world, expl, true, false);
        }
        itemstack.method_7970(16, entityLiving, class_1304.field_6173);
        if (entityLiving instanceof class_1657) {
            class_1657 player = (class_1657)entityLiving;
            player.method_7322(6.0f);
            this.setSmashed(player);
        }
    }

    public void setSmashed(class_1657 entityplayer) {
        PlayerWeaponData.setLastWarhammerSmashTicks(entityplayer, entityplayer.field_6012);
    }

    public boolean isCharged(class_1657 player) {
        return this.getCooldown(player) <= 0;
    }

    public float getScaledCooldown(class_1657 player) {
        return (float)this.getCooldown(player) / 400.0f;
    }

    public int getCooldown(class_1657 player) {
        return PlayerWeaponData.getLastWarhammerSmashTicks(player) + 400 - player.field_6012;
    }

    @Override
    @NotNull
    public class_1839 getUseAnimation(class_1799 itemstack) {
        return class_1839.field_8953;
    }

    @Override
    public int getUseDuration(class_1799 itemstack) {
        return 72000;
    }

    @Override
    @NotNull
    public class_1269 use(class_1799 itemstack, class_1937 world, class_1657 entityplayer, class_1268 hand) {
        if (itemstack.method_7960()) {
            return class_1269.field_5814;
        }
        if (this.isCharged(entityplayer)) {
            entityplayer.method_6019(hand);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderCooldown() {
        return class_310.method_1551().field_1724 != null && !this.isCharged((class_1657)class_310.method_1551().field_1724);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float getCooldown() {
        return class_310.method_1551().field_1724 == null ? 0.0f : this.getScaledCooldown((class_1657)class_310.method_1551().field_1724);
    }
}

