/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.item.ItemFlail;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityFlail
extends EntityMaterialProjectile {
    public static final String NAME = "flail";
    public boolean isSwinging;
    private float flailDamage;
    private double distanceTotal;
    private double distanceX;
    private double distanceY;
    private double distanceZ;

    public EntityFlail(World world) {
        super(world);
        this.field_70158_ak = true;
        this.flailDamage = 1.0f;
        this.distanceZ = this.distanceTotal = 0.0;
        this.distanceY = this.distanceTotal;
        this.distanceX = this.distanceTotal;
    }

    public EntityFlail(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityFlail(World worldIn, EntityLivingBase shooter, ItemStack itemstack) {
        this(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.3, shooter.field_70161_v);
        this.setThrower((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
        this.distanceTotal = 0.0;
    }

    public void func_184547_a(Entity entity, float f, float f1, float f2, float f3, float f4) {
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
        this.swing(f, f1, f3, f4);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Entity shooter = this.getThrower();
        if (shooter != null) {
            this.distanceX = shooter.field_70165_t - this.field_70165_t;
            this.distanceY = shooter.field_70163_u - this.field_70163_u;
            this.distanceZ = shooter.field_70161_v - this.field_70161_v;
            this.distanceTotal = Math.sqrt(this.distanceX * this.distanceX + this.distanceY * this.distanceY + this.distanceZ * this.distanceZ);
            if (this.distanceTotal > 3.0) {
                this.returnToOwner(true);
            }
            if (shooter instanceof EntityPlayer) {
                ItemStack itemstack = ((EntityPlayer)shooter).func_184614_ca();
                ItemStack thrownItem = (ItemStack)this.getWeapon().orNull();
                if (itemstack == null || thrownItem != null && itemstack.func_77973_b() != thrownItem.func_77973_b() || !shooter.func_70089_S()) {
                    this.pickUpByOwner();
                }
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if (this.inGround) {
            this.inGround = false;
            return;
        }
        this.returnToOwner(false);
    }

    public void returnToOwner(boolean looseFromGround) {
        Entity shooter;
        if (looseFromGround) {
            this.inGround = false;
        }
        if ((shooter = this.getThrower()) == null) {
            return;
        }
        double targetPosX = shooter.field_70165_t;
        double targetPosY = shooter.func_174813_aQ().field_72338_b + (double)0.4f;
        double targetPosZ = shooter.field_70161_v;
        float f = 27.0f;
        float f2 = 2.0f;
        this.distanceX = (targetPosX += -Math.sin((shooter.field_70177_z + f) * ((float)Math.PI / 180)) * Math.cos(shooter.field_70125_A * ((float)Math.PI / 180)) * (double)f2) - this.field_70165_t;
        this.distanceY = targetPosY - this.field_70163_u;
        this.distanceZ = (targetPosZ += Math.cos((shooter.field_70177_z + f) * ((float)Math.PI / 180)) * Math.cos(shooter.field_70125_A * ((float)Math.PI / 180)) * (double)f2) - this.field_70161_v;
        this.distanceTotal = Math.sqrt(this.distanceX * this.distanceX + this.distanceY * this.distanceY + this.distanceZ * this.distanceZ);
        if (this.distanceTotal > 3.0) {
            this.field_70165_t = targetPosX;
            this.field_70163_u = targetPosY;
            this.field_70161_v = targetPosZ;
        } else if (this.distanceTotal > 2.5) {
            this.isSwinging = false;
            this.field_70159_w *= -0.5;
            this.field_70181_x *= -0.5;
            this.field_70179_y *= -0.5;
        }
        if (!this.isSwinging) {
            float f3 = 0.2f;
            this.field_70159_w = this.distanceX * (double)f3 * this.distanceTotal;
            this.field_70181_x = this.distanceY * (double)f3 * this.distanceTotal;
            this.field_70179_y = this.distanceZ * (double)f3 * this.distanceTotal;
        }
    }

    public void pickUpByOwner() {
        this.func_70106_y();
        Entity shooter = this.getThrower();
        if (shooter instanceof EntityPlayer && this.getWeapon().isPresent()) {
            PlayerWeaponData.setFlailThrown((EntityPlayer)shooter, false);
        }
    }

    public void swing(float f, float f1, float f2, float f3) {
        if (this.isSwinging) {
            return;
        }
        this.func_184185_a(SoundEvents.field_187737_v, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, f2, f3);
        this.isSwinging = true;
        this.inGround = false;
    }

    @Override
    public void onHitEntity(RayTraceResult raytraceResult) {
        DamageSource damagesource;
        Entity entity = raytraceResult.field_72308_g;
        if (entity == this.field_70250_c) {
            return;
        }
        Entity shooter = this.getDamagingEntity();
        DamageSource damageSource = damagesource = shooter instanceof EntityLivingBase ? DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)shooter)) : WeaponDamageSource.causeProjectileWeaponDamage(this, shooter);
        if (entity.func_70097_a(damagesource, this.flailDamage + this.extraDamage)) {
            this.playHitSound();
            this.returnToOwner(true);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void bounceBack() {
        this.field_70159_w *= -0.8;
        this.field_70181_x *= -0.8;
        this.field_70179_y *= -0.8;
        this.field_70177_z += 180.0f;
        this.field_70126_B += 180.0f;
        this.ticksInAir = 0;
    }

    @Override
    public void playHitSound() {
        if (this.inGround) {
            return;
        }
        this.func_184185_a(SoundEvents.field_187800_eb, 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
    }

    @Override
    public void setThrownItemStack(ItemStack itemstack) {
        if (itemstack != null && !(itemstack.func_77973_b() instanceof ItemFlail)) {
            return;
        }
        super.setThrownItemStack(itemstack);
        this.flailDamage = itemstack == null ? 0.0f : ((ItemFlail)itemstack.func_77973_b()).getFlailDamage();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("fDmg", this.flailDamage);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.flailDamage = nbttagcompound.func_74760_g("fDmg");
    }

    @Override
    public void func_70100_b_(@Nonnull EntityPlayer entityplayer) {
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }
}

