/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityMusketBullet
extends EntityProjectile {
    public static final String NAME = "bullet";

    public EntityMusketBullet(World world) {
        super(world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
    }

    public EntityMusketBullet(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityMusketBullet(World world, EntityLivingBase shooter) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.setThrower((Entity)shooter);
    }

    public void func_184547_a(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, f3, f4);
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.inGround) {
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
            return;
        }
        double speed = this.getTotalVelocity();
        double amount = 16.0;
        if (speed > 2.0) {
            int i1 = 1;
            while ((double)i1 < amount) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70159_w * (double)i1 / amount, this.field_70163_u + this.field_70181_x * (double)i1 / amount, this.field_70161_v + this.field_70179_y * (double)i1 / amount, 0.0, 0.0, 0.0, new int[0]);
                ++i1;
            }
        }
    }

    @Override
    public void onHitEntity(RayTraceResult raytraceResult) {
        Entity entity = raytraceResult.field_72308_g;
        float damage = 20.0f + this.extraDamage;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        if (entity.func_70097_a(damagesource, damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.func_70106_y();
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxLifetime() {
        return 200;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public float getGravity() {
        return this.getTotalVelocity() < 3.0 ? 0.07f : 0.0f;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack((Item)BalkonsWeaponMod.musketBullet);
    }
}

