/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeCompHalberd;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMelee
extends ItemSword
implements IItemWeapon {
    public final MeleeComponent meleeComponent;

    public ItemMelee(String id, MeleeComponent meleecomponent) {
        this("weaponmod", id, meleecomponent);
    }

    public ItemMelee(String modId, String id, MeleeComponent meleecomponent) {
        super(meleecomponent.weaponMaterial == null ? Item.ToolMaterial.WOOD : meleecomponent.weaponMaterial);
        this.setRegistryName(new ResourceLocation(modId, id));
        this.func_77655_b(id);
        this.meleeComponent = meleecomponent;
        this.meleeComponent.setItem(this);
        meleecomponent.setThisItemProperties();
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.func_185043_a(new ResourceLocation("weaponmod", "ready-to-throw"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("weaponmod", "state"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return MeleeCompHalberd.getHalberdState(stack) ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("weaponmod", "block"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public float func_150931_i() {
        return this.meleeComponent.getEntityDamageMaterialPart();
    }

    public float func_150893_a(@Nonnull ItemStack itemstack, @Nonnull IBlockState block) {
        return this.meleeComponent.getBlockDamage(itemstack, block);
    }

    public boolean func_150897_b(@Nonnull IBlockState block) {
        return this.meleeComponent.canHarvestBlock(block);
    }

    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        return this.meleeComponent.hitEntity(itemstack, entityliving, attacker);
    }

    public boolean func_179218_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull IBlockState block, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entityliving) {
        return this.meleeComponent.onBlockDestroyed(itemstack, world, block, pos, entityliving);
    }

    public int func_77619_b() {
        return this.meleeComponent.getItemEnchantability();
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack itemstack) {
        return this.meleeComponent.getItemUseAction(itemstack);
    }

    public int func_77626_a(@Nonnull ItemStack itemstack) {
        return this.meleeComponent.getMaxItemUseDuration(itemstack);
    }

    @Override
    public boolean onLeftClickEntity(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityPlayer entityplayer, @Nonnull EnumHand hand) {
        return this.meleeComponent.onItemRightClick(stack, world, entityplayer, hand);
    }

    public void onUsingTick(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityplayer, int count) {
        this.meleeComponent.onUsingTick(itemstack, entityplayer, count);
    }

    public void func_77615_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull EntityLivingBase entityplayer, int i) {
        this.meleeComponent.onPlayerStoppedUsing(itemstack, world, entityplayer, i);
    }

    public void func_77663_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull Entity entity, int i, boolean flag) {
        this.meleeComponent.onUpdate(itemstack, world, entity, i, flag);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack itemstack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            this.meleeComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        }
        return multimap;
    }

    @Override
    public Random getItemRand() {
        return field_77697_d;
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return null;
    }
}

