/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.IExtendedReachItem;
import ckathode.weaponmod.item.IItemWeapon;
import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MeleeComponent
extends AbstractWeaponComponent {
    public final MeleeSpecs meleeSpecs;
    public final Item.ToolMaterial weaponMaterial;

    public MeleeComponent(MeleeSpecs meleespecs, Item.ToolMaterial toolmaterial) {
        this.meleeSpecs = meleespecs;
        this.weaponMaterial = toolmaterial;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public void setThisItemProperties() {
        this.item.func_77656_e(this.weaponMaterial == null ? this.meleeSpecs.durabilityBase : (int)((float)this.meleeSpecs.durabilityBase + (float)this.weaponMaterial.func_77997_a() * this.meleeSpecs.durabilityMult));
    }

    @Override
    public float getEntityDamageMaterialPart() {
        if (this.weaponMaterial == null) {
            return 0.0f;
        }
        return this.weaponMaterial.func_78000_c() * this.meleeSpecs.damageMult;
    }

    @Override
    public float getEntityDamage() {
        return this.meleeSpecs.damageBase + this.getEntityDamageMaterialPart();
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, IBlockState block) {
        if (this.canHarvestBlock(block)) {
            return this.meleeSpecs.blockDamage * 10.0f;
        }
        Material material = block.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : this.meleeSpecs.blockDamage;
    }

    @Override
    public boolean canHarvestBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150321_G;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, IBlockState block, BlockPos pos, EntityLivingBase entityliving) {
        if (block.func_185887_b(world, pos) != 0.0f) {
            itemstack.func_77972_a(this.meleeSpecs.dmgFromBlock, entityliving);
        }
        return true;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (entityliving.field_70172_ad == entityliving.field_70771_an) {
            float kb = this.getKnockBack(itemstack, entityliving, attacker);
            PhysHelper.knockBack(entityliving, attacker, kb);
            if (this.meleeSpecs.attackDelay >= 3.0f) {
                entityliving.field_70172_ad += (int)this.getAttackDelay(itemstack, entityliving, attacker);
            } else {
                float f = this.meleeSpecs.attackDelay < 1.0f ? 1.2f : 2.0f;
                entityliving.field_70172_ad -= (int)(f / this.getAttackDelay(itemstack, entityliving, attacker));
            }
        }
        itemstack.func_77972_a(this.meleeSpecs.dmgFromEntity, attacker);
        return true;
    }

    @Override
    public float getAttackDelay(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return this.meleeSpecs.attackDelay;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return this.meleeSpecs.getKnockBack(this.weaponMaterial);
    }

    @Override
    public int getItemEnchantability() {
        return this.weaponMaterial == null ? 1 : this.weaponMaterial.func_77995_e();
    }

    @Override
    public void addItemAttributeModifiers(Multimap<String, AttributeModifier> multimap) {
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.meleeSpecs.damageMult > 0.0f) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.ATTACK_DAMAGE_MODIFIER, "Weapon attack damage modifier", (double)dmg, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.ATTACK_SPEED_MODIFIER, "Weapon attack speed modifier", (double)(-this.meleeSpecs.attackDelay), 0));
        }
        if (this.meleeSpecs.getKnockBack(this.weaponMaterial) != 0.4f) {
            multimap.put((Object)WeaponModAttributes.WEAPON_KNOCKBACK.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.KNOCKBACK_MODIFIER, "Weapon knockback modifier", (double)(this.meleeSpecs.getKnockBack(this.weaponMaterial) - 0.4f), 0));
        }
        if (this instanceof IExtendedReachItem) {
            try {
                multimap.put((Object)WeaponModAttributes.WEAPON_REACH.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.REACH_MODIFIER, "Weapon reach modifier", (double)(((IExtendedReachItem)((Object)this)).getExtendedReach(null, null, null) - 3.0f), 0));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            PhysHelper.prepareKnockbackOnEntity((EntityLivingBase)player, (EntityLivingBase)entity);
        }
        return false;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.BLOCK;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer, EnumHand hand) {
        if (this.getItemUseAction(itemstack) != EnumAction.NONE) {
            entityplayer.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @Override
    public void onUsingTick(ItemStack itemstack, EntityLivingBase entityliving, int count) {
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityLivingBase entityliving, int i) {
    }

    @Override
    public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderCooldown() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCooldown() {
        return 0.0f;
    }

    public static enum MeleeSpecs {
        SPEAR(0, 1.0f, 3.0f, 1.0f, 1.0f, 0.2f, 1, 2, 2.7f),
        HALBERD(0, 1.0f, 4.0f, 1.0f, 1.5f, 0.6f, 1, 2, 3.2f),
        BATTLEAXE(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.5f, 1, 2, 3.0f),
        WARHAMMER(0, 1.0f, 4.0f, 1.0f, 1.0f, 0.7f, 1, 2, 3.0f),
        KNIFE(0, 0.5f, 3.0f, 1.0f, 1.5f, 0.2f, 1, 2, 2.0f),
        KATANA(0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1, 2, 0.2f),
        FIREROD(1, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 2, 0, 0.0f),
        BOOMERANG(0, 0.5f, 2.0f, 1.0f, 1.0f, 0.4f, 1, 1, 2.0f),
        NONE(0, 1.0f, 1.0f, 0.0f, 1.0f, 0.4f, 0, 0, 0.0f);

        public final int durabilityBase;
        public final float durabilityMult;
        public final float damageBase;
        public final float damageMult;
        public final float blockDamage;
        public final float knockback;
        public final float attackDelay;
        public final int dmgFromEntity;
        public final int dmgFromBlock;

        private MeleeSpecs(int durbase, float durmult, float dmgbase, float dmgmult, float blockdmg, float knockback, int dmgfromentity, int dmgfromblock, float attackdelay) {
            this.durabilityBase = durbase;
            this.durabilityMult = durmult;
            this.damageBase = dmgbase;
            this.damageMult = dmgmult;
            this.blockDamage = blockdmg;
            this.knockback = knockback;
            this.dmgFromEntity = dmgfromentity;
            this.dmgFromBlock = dmgfromblock;
            this.attackDelay = attackdelay;
        }

        public float getKnockBack(Item.ToolMaterial material) {
            return material == Item.ToolMaterial.GOLD ? this.knockback * 1.5f : this.knockback;
        }
    }
}

