/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.BalkonsWeaponMod;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.player.Player;

public final class PlayerWeaponData {
    private static final EntityDataAccessor<Integer> WARHAMMER_LAST_SMASH_TICKS = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FLAIL_THROWN = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FLAIL_ENTITY_ID = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public static void initPlayerWeaponData(Player player, SynchedEntityData.Builder builder) {
        String playername = PlayerWeaponData.getPlayerName(player);
        BalkonsWeaponMod.LOGGER.trace("Initializing DataManager values for {}", (Object)playername);
        SynchedEntityData dataManager = player.getEntityData();
        try {
            dataManager.get(WARHAMMER_LAST_SMASH_TICKS);
            BalkonsWeaponMod.LOGGER.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)WARHAMMER_LAST_SMASH_TICKS.id());
        }
        catch (Throwable ignored) {
            if (builder == null) {
                dataManager.set(WARHAMMER_LAST_SMASH_TICKS, (Object)player.tickCount, true);
            }
            builder.define(WARHAMMER_LAST_SMASH_TICKS, (Object)player.tickCount);
        }
        try {
            dataManager.get(FLAIL_THROWN);
            BalkonsWeaponMod.LOGGER.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)FLAIL_THROWN.id());
        }
        catch (Throwable ignored) {
            if (builder == null) {
                dataManager.set(FLAIL_THROWN, (Object)false, true);
            }
            builder.define(FLAIL_THROWN, (Object)false);
        }
        try {
            dataManager.get(FLAIL_ENTITY_ID);
            BalkonsWeaponMod.LOGGER.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)FLAIL_ENTITY_ID.id());
        }
        catch (Throwable ignored) {
            if (builder == null) {
                dataManager.set(FLAIL_ENTITY_ID, (Object)0, true);
            }
            builder.define(FLAIL_ENTITY_ID, (Object)0);
        }
    }

    private static String getPlayerName(Player player) {
        String playername = player.getGameProfile() != null ? player.getGameProfile().getName() : "[unknown]";
        return "player:" + playername;
    }

    private static void unavailableError(Player player, int id) {
        BalkonsWeaponMod.LOGGER.error("DataManager ID {} for {} unavailable, trying to reinitialize", (Object)id, (Object)PlayerWeaponData.getPlayerName(player));
        PlayerWeaponData.initPlayerWeaponData(player, null);
    }

    public static int getLastWarhammerSmashTicks(Player player) {
        try {
            return (Integer)player.getEntityData().get(WARHAMMER_LAST_SMASH_TICKS);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS.id());
            return 0;
        }
    }

    public static void setLastWarhammerSmashTicks(Player player, int age) {
        try {
            player.getEntityData().set(WARHAMMER_LAST_SMASH_TICKS, (Object)age);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS.id());
        }
    }

    public static boolean isFlailThrown(Player player) {
        try {
            return (Boolean)player.getEntityData().get(FLAIL_THROWN);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN.id());
            return false;
        }
    }

    public static void setFlailThrown(Player player, boolean flag) {
        try {
            player.getEntityData().set(FLAIL_THROWN, (Object)flag);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN.id());
        }
    }

    public static int getFlailEntityId(Player player) {
        try {
            return (Integer)player.getEntityData().get(FLAIL_ENTITY_ID);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID.id());
            return 0;
        }
    }

    public static void setFlailEntityId(Player player, int id) {
        try {
            player.getEntityData().set(FLAIL_ENTITY_ID, (Object)id);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID.id());
        }
    }

    public static void init() {
    }
}

