/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.neoforge.EntityProjectileImpl;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityProjectile<T extends EntityProjectile<T>>
extends AbstractArrow
implements EntitySpawnExtension {
    private static final EntityDataAccessor<Byte> WEAPON_CRITICAL = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    @Nullable
    protected BlockState inBlockState = null;
    protected boolean inGround = false;
    public PickupStatus pickupStatus;
    protected int ticksInGround;
    protected int ticksInAir;
    public boolean beenInGround;
    public float extraDamage;
    private Entity shooter;
    @Nullable
    private ItemStack firedFromWeapon = null;

    public EntityProjectile(EntityType<T> type, Level world) {
        super(type, world);
        this.shakeTime = 0;
        this.ticksInAir = 0;
        this.pickupStatus = PickupStatus.DISALLOWED;
        this.extraDamage = 0.0f;
    }

    public EntityProjectile(EntityType<T> type, Level level, @Nullable ItemStack firedFromWeapon) {
        this(type, level);
        if (firedFromWeapon != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.firedFromWeapon = firedFromWeapon.copy();
            if (this.firedFromWeapon.isEmpty()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            EnchantmentHelper.onProjectileSpawned((ServerLevel)serverLevel, (ItemStack)this.firedFromWeapon, this, item -> {
                this.firedFromWeapon = null;
            });
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WEAPON_CRITICAL, (Object)0);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        Entity shooter = this.getOwner();
        buf.writeInt(shooter != null ? shooter.getId() : -1);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        int shooterId = buf.readInt();
        if (shooterId >= 0) {
            this.setOwner(this.level().getEntity(shooterId));
        }
    }

    public void setOwner(@Nullable Entity shooter) {
        this.shooter = shooter;
        super.setOwner(shooter);
    }

    @Nullable
    public Entity getOwner() {
        if (this.shooter != null) {
            return this.shooter;
        }
        return super.getOwner();
    }

    protected void setPickupStatusFromEntity(LivingEntity entityliving) {
        if (entityliving instanceof Player) {
            Player player = (Player)entityliving;
            if (player.isCreative()) {
                this.setPickupStatus(PickupStatus.CREATIVE_ONLY);
            } else {
                this.setPickupStatus(WeaponModConfig.get().allCanPickup ? PickupStatus.ALLOWED : PickupStatus.OWNER_ONLY);
            }
        } else {
            this.setPickupStatus(PickupStatus.DISALLOWED);
        }
    }

    public Entity getDamagingEntity() {
        Entity shooter = this.getOwner();
        return shooter != null ? shooter : this;
    }

    public void shoot(double x, double y, double z, float speed, float deviation) {
        Vec3 v = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * 0.0075 * (double)deviation, this.random.nextGaussian() * 0.0075 * (double)deviation, this.random.nextGaussian() * 0.0075 * (double)deviation).scale((double)speed);
        this.setDeltaMovement(v);
        double f2 = v.horizontalDistance();
        float n = (float)(Mth.atan2((double)v.x, (double)v.z) * 180.0 / Math.PI);
        this.setYRot(n);
        this.yRotO = n;
        float n2 = (float)(Mth.atan2((double)v.y, (double)f2) * 180.0 / Math.PI);
        this.setXRot(n2);
        this.xRotO = n2;
        this.ticksInGround = 0;
    }

    public void lerpMotion(double d, double d1, double d2) {
        Vec3 v = new Vec3(d, d1, d2);
        this.setDeltaMovement(v);
        if (this.aimRotation() && this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = v.horizontalDistance();
            float n = (float)(Mth.atan2((double)d, (double)d2) * 180.0 / Math.PI);
            this.setYRot(n);
            this.yRotO = n;
            float n2 = (float)(Mth.atan2((double)d1, (double)f) * 180.0 / Math.PI);
            this.setXRot(n2);
            this.xRotO = n2;
            this.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            this.ticksInGround = 0;
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        VoxelShape voxelShape;
        super.baseTick();
        Vec3 motion = this.getDeltaMovement();
        if (this.aimRotation() && this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = motion.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 180.0 / Math.PI));
            this.setXRot((float)(Mth.atan2((double)motion.y, (double)f) * 180.0 / Math.PI));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        BlockState iblockstate = this.level().getBlockState(blockpos);
        if (!iblockstate.isAir() && !(voxelShape = iblockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty() && voxelShape.bounds().move(blockpos).contains(new Vec3(this.getX(), this.getY(), this.getZ()))) {
            this.inGround = true;
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain()) {
            this.clearFire();
        }
        if (this.inGround) {
            if (!iblockstate.equals((Object)this.inBlockState) && this.level().noCollision(this.getBoundingBox().inflate(0.06))) {
                this.inGround = false;
                this.setDeltaMovement(motion.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.level().isClientSide) {
                ++this.ticksInGround;
                int t = this.getMaxLifetime();
                if (t != 0 && this.ticksInGround >= t) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
            ++this.inGroundTime;
            return;
        }
        this.inGroundTime = 0;
        ++this.ticksInAir;
        Vec3 vec3d = this.position();
        Vec3 vec3d2 = vec3d.add(this.getDeltaMovement());
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            vec3d2 = raytraceresult.getLocation();
        }
        while (this.isAlive()) {
            EntityHitResult entityraytraceresult = this.findHitEntity(vec3d, vec3d2);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult instanceof EntityHitResult) {
                EntityHitResult ehr = (EntityHitResult)raytraceresult;
                Entity entity = ehr.getEntity();
                Entity entity2 = this.getOwner();
                if (entity instanceof Player) {
                    Player player2;
                    Player player = (Player)entity;
                    if (entity2 instanceof Player && !(player2 = (Player)entity2).canHarmPlayer(player)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
            }
            if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS && !EntityProjectile.onProjectileImpact(this, (HitResult)raytraceresult)) {
                this.onHit((HitResult)raytraceresult);
                this.hasImpulse = true;
            }
            if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
            raytraceresult = null;
        }
        if (this.isCritArrow()) {
            Vec3 motion2 = this.getDeltaMovement();
            for (int i1 = 0; i1 < 2; ++i1) {
                Vec3 pos = this.position().add(motion2.scale((double)i1 / 4.0));
                if (!this.level().isClientSide()) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, pos.x, pos.y, pos.z, -motion2.x, -motion2.y + 0.2, -motion2.z);
            }
        }
        Vec3 newPos = this.position().add(this.getDeltaMovement());
        this.setPos(newPos.x, newPos.y, newPos.z);
        if (this.aimRotation()) {
            float n4;
            Vec3 motion2 = this.getDeltaMovement();
            double f2 = motion2.horizontalDistance();
            float n3 = (float)(Mth.atan2((double)motion2.x, (double)motion2.z) * 180.0 / Math.PI);
            this.setYRot(n3);
            this.yRotO = n3;
            this.xRot = n4 = (float)(Mth.atan2((double)motion2.y, (double)f2) * 180.0 / Math.PI);
            this.xRotO = n4;
        }
        float res = this.getAirResistance();
        double grav = this.getGravity();
        if (this.isInWater()) {
            Vec3 motion2 = this.getDeltaMovement();
            this.beenInGround = true;
            for (int i2 = 0; i2 < 4; ++i2) {
                float f3 = 0.25f;
                Vec3 pos = this.position().subtract(motion2.scale((double)f3));
                if (!this.level().isClientSide()) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, pos.x, pos.y, pos.z, motion2.x, motion2.y + 0.2, motion2.z);
            }
            res *= 0.6f;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)res).subtract(0.0, this.isNoGravity() ? 0.0 : grav, 0.0));
        this.setPos(this.getX(), this.getY(), this.getZ());
        this.applyEffectsFromBlocks();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean onProjectileImpact(EntityProjectile<?> projectile, HitResult hitResult) {
        void var1_1;
        return EntityProjectileImpl.onProjectileImpact(projectile, (HitResult)var1_1);
    }

    public void onHit(@NotNull HitResult result) {
        if (result instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)result;
            this.onHitEntity(ehr);
        } else if (result instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)result;
            this.onHitBlock(bhr);
        }
    }

    public void onHitEntity(EntityHitResult result) {
        this.bounceBack();
        this.applyEntityHitEffects(result.getEntity());
    }

    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().arrow((AbstractArrow)this, this.shooter);
    }

    public void applyEntityHitEffects(Entity entity) {
        if (this.isOnFire() && !(entity instanceof EnderMan)) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity instanceof LivingEntity) {
            Entity shooter;
            LivingEntity livingEntity = (LivingEntity)entity;
            this.doKnockback(livingEntity, this.getDamageSource());
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)livingEntity, (DamageSource)this.getDamageSource(), (ItemStack)this.getWeaponItem());
            }
            if ((shooter = this.getOwner()) instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)shooter;
                if (!entity.equals((Object)this.getOwner()) && entity instanceof Player) {
                    sp.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.PLAY_ARROW_HIT_SOUND, 0.0f));
                }
            }
        }
    }

    public void onHitBlock(BlockHitResult result) {
        BlockPos blockpos = result.getBlockPos();
        this.xTile = blockpos.getX();
        this.yTile = blockpos.getY();
        this.zTile = blockpos.getZ();
        this.inBlockState = this.level().getBlockState(blockpos);
        this.setDeltaMovement(result.getLocation().subtract(this.position()));
        double f1 = this.getDeltaMovement().length();
        Vec3 pos = this.position().subtract(this.getDeltaMovement().scale(0.05 / f1));
        this.setPos(pos.x, pos.y, pos.z);
        this.inGround = true;
        this.beenInGround = true;
        this.setCritArrow(false);
        this.shakeTime = this.getMaxArrowShake();
        this.playHitSound();
        if (this.inBlockState != null) {
            this.inBlockState.entityInside(this.level(), blockpos, (Entity)this, InsideBlockEffectApplier.NOOP);
        }
    }

    protected void bounceBack() {
        this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
        this.setYRot(this.getYRot() + 180.0f);
        this.yRotO += 180.0f;
        this.ticksInAir = 0;
    }

    public double getTotalVelocity() {
        return this.getDeltaMovement().length();
    }

    public boolean aimRotation() {
        return true;
    }

    public int getMaxLifetime() {
        return 1200;
    }

    public float getAirResistance() {
        return 0.99f;
    }

    public double getDefaultGravity() {
        return 0.05;
    }

    public int getMaxArrowShake() {
        return 7;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return this.getDefaultPickupItem();
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.getPickupItem();
    }

    public void playHitSound() {
    }

    public boolean canBeCritical() {
        return false;
    }

    public void setCritArrow(boolean flag) {
        if (this.canBeCritical()) {
            this.entityData.set(WEAPON_CRITICAL, (Object)((byte)(flag ? 1 : 0)));
        }
    }

    public boolean isCritArrow() {
        return this.canBeCritical() && (Byte)this.entityData.get(WEAPON_CRITICAL) != 0;
    }

    public void setExtraDamage(float f) {
        this.extraDamage = f;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        float f;
        Level level = this.level();
        if (this.firedFromWeapon != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)serverLevel, (ItemStack)this.firedFromWeapon, (Entity)livingEntity, (DamageSource)damageSource, (float)0.0f);
        } else {
            f = 0.0f;
        }
        double d = f;
        if (d > 0.0) {
            double e = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d * 0.6 * e);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    public void setPickupStatus(PickupStatus i) {
        this.pickupStatus = i;
    }

    public PickupStatus getPickupStatus() {
        return this.pickupStatus;
    }

    public boolean canPickup(Player entityplayer) {
        if (this.pickupStatus == PickupStatus.ALLOWED) {
            return true;
        }
        if (this.pickupStatus == PickupStatus.CREATIVE_ONLY) {
            return entityplayer.isCreative();
        }
        return this.pickupStatus == PickupStatus.OWNER_ONLY && entityplayer.equals((Object)this.getOwner());
    }

    public void playerTouch(@NotNull Player entityplayer) {
        if (this.inGround && this.shakeTime <= 0 && this.canPickup(entityplayer) && !this.level().isClientSide) {
            ItemStack item = this.getPickupItem();
            if (item.isEmpty()) {
                return;
            }
            if (this.pickupStatus == PickupStatus.CREATIVE_ONLY && entityplayer.isCreative() || entityplayer.getInventory().add(item)) {
                this.playSound(SoundEvents.ITEM_PICKUP, 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void onItemPickup(Player entityplayer) {
        entityplayer.take((Entity)this, 1);
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    public void addAdditionalSaveData(CompoundTag nbttagcompound) {
        nbttagcompound.putInt("xTile", this.xTile);
        nbttagcompound.putInt("yTile", this.yTile);
        nbttagcompound.putInt("zTile", this.zTile);
        if (this.inBlockState != null) {
            nbttagcompound.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.inBlockState));
        }
        nbttagcompound.putByte("shake", (byte)this.shakeTime);
        nbttagcompound.putBoolean("inGround", this.inGround);
        nbttagcompound.putBoolean("beenInGround", this.beenInGround);
        nbttagcompound.putByte("pickup", (byte)this.pickupStatus.ordinal());
        if (this.firedFromWeapon != null) {
            nbttagcompound.put("weapon", this.firedFromWeapon.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
    }

    public void readAdditionalSaveData(CompoundTag nbttagcompound) {
        RegistryOps registryops = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.xTile = nbttagcompound.getIntOr("xTile", (int)this.getX());
        this.yTile = nbttagcompound.getIntOr("yTile", (int)this.getY());
        this.zTile = nbttagcompound.getIntOr("zTile", (int)this.getZ());
        this.inBlockState = nbttagcompound.read("inBlockState", BlockState.CODEC, (DynamicOps)registryops).orElse(null);
        this.shakeTime = nbttagcompound.getByteOr("shake", (byte)0) & 0xFF;
        this.inGround = nbttagcompound.getBooleanOr("inGround", false);
        this.beenInGround = nbttagcompound.getBooleanOr("beenInGround", false);
        this.pickupStatus = nbttagcompound.read("pickup", PickupStatus.CODEC).orElse(PickupStatus.DISALLOWED);
        this.firedFromWeapon = nbttagcompound.read("weapon", ItemStack.CODEC, (DynamicOps)registryops).orElse(null);
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY,
        OWNER_ONLY;

        public static final Codec<PickupStatus> CODEC;

        public static PickupStatus getByOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }

        static {
            CODEC = Codec.BYTE.xmap(PickupStatus::getByOrdinal, status -> (byte)status.ordinal());
        }
    }
}

