/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.MeleeCompKnife;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedCompMusket;
import ckathode.weaponmod.item.RangedComponent;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMusket
extends ItemShooter {
    public static final String ID = "musket";
    public static final ItemMusket ITEM = WMItemBuilder.createStandardMusket(BalkonsWeaponMod.id("musket"));
    public static final String WOOD_ID = "musketbayonet.wood";
    public static final ItemMusket WOOD_ITEM = WMItemBuilder.createStandardMusketWithBayonet(ToolMaterial.WOOD, MeleeCompKnife.WOOD_ITEM, BalkonsWeaponMod.id("musketbayonet.wood"));
    public static final String STONE_ID = "musketbayonet.stone";
    public static final ItemMusket STONE_ITEM = WMItemBuilder.createStandardMusketWithBayonet(ToolMaterial.STONE, MeleeCompKnife.STONE_ITEM, BalkonsWeaponMod.id("musketbayonet.stone"));
    public static final String IRON_ID = "musketbayonet.iron";
    public static final ItemMusket IRON_ITEM = WMItemBuilder.createStandardMusketWithBayonet(ToolMaterial.IRON, MeleeCompKnife.IRON_ITEM, BalkonsWeaponMod.id("musketbayonet.iron"));
    public static final String GOLD_ID = "musketbayonet.gold";
    public static final ItemMusket GOLD_ITEM = WMItemBuilder.createStandardMusketWithBayonet(ToolMaterial.GOLD, MeleeCompKnife.GOLD_ITEM, BalkonsWeaponMod.id("musketbayonet.gold"));
    public static final String DIAMOND_ID = "musketbayonet.diamond";
    public static final ItemMusket DIAMOND_ITEM = WMItemBuilder.createStandardMusketWithBayonet(ToolMaterial.DIAMOND, MeleeCompKnife.DIAMOND_ITEM, BalkonsWeaponMod.id("musketbayonet.diamond"));
    public static final String NETHERITE_ID = "musketbayonet.netherite";
    public static final ItemMusket NETHERITE_ITEM = WMItemBuilder.createStandardMusketWithBayonet(ToolMaterial.NETHERITE, MeleeCompKnife.NETHERITE_ITEM, BalkonsWeaponMod.id("musketbayonet.netherite"));
    public static final String BAYONET_DAMAGE_TYPE_ID = "bayonet-damage";
    public static final DataComponentType<Short> BAYONET_DAMAGE_TYPE = DataComponentType.builder().persistent((Codec)Codec.SHORT).networkSynchronized(ByteBufCodecs.SHORT).build();
    @Nullable
    protected final Item bayonetItem;
    private final int bayonetDurability;

    public ItemMusket(MeleeComponent meleecomponent, @Nullable Item bayonetitem, @NotNull ResourceLocation id) {
        super((RangedComponent)new RangedCompMusket(), meleecomponent, id);
        this.bayonetItem = bayonetitem;
        this.bayonetDurability = meleecomponent.meleeSpecs != MeleeComponent.MeleeSpecs.NONE && meleecomponent.weaponMaterial != null ? meleecomponent.meleeSpecs.durabilityBase + (int)((float)meleecomponent.weaponMaterial.durability() * meleecomponent.meleeSpecs.durabilityMult) : 0;
    }

    public boolean hasBayonet() {
        return this.bayonetItem != null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        short dmg;
        super.appendHoverText(stack, context, tooltipDisplay, consumer, tooltipFlag);
        if (this.hasBayonet() && stack.has(BAYONET_DAMAGE_TYPE) && (dmg = Objects.requireNonNull((Short)stack.get(BAYONET_DAMAGE_TYPE)).shortValue()) != 0) {
            consumer.accept((Component)Component.translatable((String)"tooltip.bayonetdurability", (Object[])new Object[]{this.bayonetDurability - dmg, this.bayonetDurability}));
        }
    }

    @Override
    public void hurtEnemy(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity attacker) {
        if (this.hasBayonet()) {
            Player player;
            int n = entityliving.invulnerableTime;
            Objects.requireNonNull(entityliving);
            if (n == 20) {
                float kb = this.meleeComponent.getKnockBack(itemstack, entityliving, attacker);
                PhysHelper.knockBack(entityliving, attacker, kb);
                entityliving.invulnerableTime -= (int)(2.0f / this.meleeComponent.meleeSpecs.attackDelay);
            }
            if (attacker instanceof Player && !(player = (Player)attacker).isCreative()) {
                this.bayonetDamage(itemstack, attacker, 1);
            }
        }
    }

    @Override
    public boolean mineBlock(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState block, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        if (this.hasBayonet()) {
            Player player;
            boolean flag;
            boolean bl = flag = block.is(BlockTags.SWORD_EFFICIENT) || block.is(Blocks.COBWEB);
            if (entityliving instanceof Player && !(player = (Player)entityliving).isCreative() && !flag) {
                this.bayonetDamage(itemstack, (LivingEntity)player, 2);
            }
        }
        return true;
    }

    public void bayonetDamage(ItemStack itemstack, LivingEntity entityliving, int damage) {
        int bayonetdamage;
        if (!itemstack.has(BAYONET_DAMAGE_TYPE)) {
            itemstack.set(BAYONET_DAMAGE_TYPE, (Object)0);
        }
        if ((bayonetdamage = Objects.requireNonNull((Short)itemstack.get(BAYONET_DAMAGE_TYPE)) + damage) > this.bayonetDurability) {
            entityliving.onEquippedItemBroken((Item)this, EquipmentSlot.MAINHAND);
            if (entityliving instanceof Player) {
                Player player = (Player)entityliving;
                player.awardStat(Stats.ITEM_BROKEN.get((Object)this));
            }
            bayonetdamage = 0;
            ItemStack itemstack2 = new ItemStack((ItemLike)WMRegistries.ITEM_MUSKET.get(), 1);
            itemstack2.setDamageValue(itemstack.getDamageValue());
            entityliving.setItemSlot(EquipmentSlot.MAINHAND, itemstack2);
            if (itemstack.has(ReloadHelper.ReloadState.TYPE)) {
                ReloadHelper.setReloadState(itemstack2, ReloadHelper.getReloadState(itemstack));
            }
        }
        itemstack.set(BAYONET_DAMAGE_TYPE, (Object)((short)bayonetdamage));
    }
}

