/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.IExtendedReachItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeleeComponent
extends AbstractWeaponComponent {
    public final MeleeSpecs meleeSpecs;
    public final ToolMaterial weaponMaterial;

    public MeleeComponent(MeleeSpecs meleespecs, ToolMaterial itemTier) {
        this.meleeSpecs = meleespecs;
        this.weaponMaterial = itemTier;
    }

    @NotNull
    public ToolMaterial getWeaponMaterial() {
        return this.weaponMaterial == null ? ToolMaterial.WOOD : this.weaponMaterial;
    }

    @Override
    protected void onSetItem() {
    }

    @NotNull
    public Tool getToolComponent() {
        HolderGetter holderGetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return new Tool(List.of(Tool.Rule.minesAndDrops((HolderSet)HolderSet.direct((Holder[])new Holder[]{Blocks.COBWEB.builtInRegistryHolder()}), (float)(this.meleeSpecs.blockDamage * 10.0f)), Tool.Rule.overrideSpeed((HolderSet)holderGetter.getOrThrow(BlockTags.SWORD_EFFICIENT), (float)this.meleeSpecs.blockDamage)), 1.0f, 2, false);
    }

    @Override
    public ItemAttributeModifiers.Builder setAttributes(ItemAttributeModifiers.Builder attributeBuilder) {
        MeleeComponent meleeComponent;
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.meleeSpecs.damageMult > 0.0f) {
            attributeBuilder = attributeBuilder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)(-this.meleeSpecs.attackDelay), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        if (this.meleeSpecs.getKnockBack(this.weaponMaterial) != 0.4f) {
            attributeBuilder = attributeBuilder.add(WMRegistries.WEAPON_KNOCKBACK, new AttributeModifier(WeaponModAttributes.WEAPON_KNOCKBACK_ID, (double)(this.meleeSpecs.getKnockBack(this.weaponMaterial) - 0.4f), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        if ((meleeComponent = this) instanceof IExtendedReachItem) {
            IExtendedReachItem ieri = (IExtendedReachItem)((Object)meleeComponent);
            try {
                attributeBuilder = attributeBuilder.add(WMRegistries.WEAPON_REACH, new AttributeModifier(WeaponModAttributes.WEAPON_REACH_ID, (double)(ieri.getExtendedReach(null, null, null) - 3.0f), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return attributeBuilder;
    }

    @Override
    public Item.Properties setProperties(Item.Properties properties) {
        return properties.component(DataComponents.TOOL, (Object)this.getToolComponent()).durability(this.weaponMaterial == null ? this.meleeSpecs.durabilityBase : (int)((float)this.meleeSpecs.durabilityBase + (float)this.weaponMaterial.durability() * this.meleeSpecs.durabilityMult));
    }

    @Override
    public float getDamage() {
        if (this.weaponMaterial == null) {
            return 0.0f;
        }
        return this.weaponMaterial.attackDamageBonus() * this.meleeSpecs.damageMult;
    }

    @Override
    public float getEntityDamage() {
        return this.meleeSpecs.damageBase + this.getDamage();
    }

    @Override
    public boolean mineBlock(ItemStack itemstack, Level world, BlockState block, BlockPos pos, LivingEntity entityliving) {
        if (block.getDestroySpeed((BlockGetter)world, pos) != 0.0f) {
            itemstack.hurtAndBreak(this.meleeSpecs.dmgFromBlock, entityliving, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    @Override
    public void hurtEnemy(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity attacker) {
        int n = entityliving.invulnerableTime;
        Objects.requireNonNull(entityliving);
        if (n == 20) {
            float kb = this.getKnockBack(itemstack, entityliving, attacker);
            PhysHelper.knockBack(entityliving, attacker, kb);
            if (this.meleeSpecs.attackDelay >= 3.0f) {
                entityliving.invulnerableTime += (int)this.getAttackDelay(itemstack, entityliving, attacker);
            } else {
                float f = this.meleeSpecs.attackDelay < 1.0f ? 1.2f : 2.0f;
                entityliving.invulnerableTime -= (int)(f / this.getAttackDelay(itemstack, entityliving, attacker));
            }
        }
        itemstack.hurtAndBreak(this.meleeSpecs.dmgFromEntity, attacker, EquipmentSlot.MAINHAND);
    }

    @Override
    public float getAttackDelay(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        return this.meleeSpecs.attackDelay;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        return this.meleeSpecs.getKnockBack(this.weaponMaterial);
    }

    @Override
    public int getEnchantmentValue() {
        return this.weaponMaterial == null ? 1 : this.weaponMaterial.enchantmentValue();
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            PhysHelper.prepareKnockbackOnEntity((LivingEntity)player, livingEntity);
        }
        return false;
    }

    @Override
    @NotNull
    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.BLOCK;
    }

    @Override
    public int getUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    @NotNull
    public InteractionResult use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        if (this.getUseAnimation(itemstack) != ItemUseAnimation.NONE) {
            entityplayer.startUsingItem(hand);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onUsingTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
    }

    @Override
    public boolean releaseUsing(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        return false;
    }

    @Override
    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull ServerLevel serverLevel, @NotNull Entity entity, @Nullable EquipmentSlot equipmentSlot) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderCooldown() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCooldown() {
        return 0.0f;
    }

    public static enum MeleeSpecs {
        SPEAR(0, 1.0f, 3.0f, 1.0f, 1.0f, 0.2f, 1, 2, 2.7f),
        HALBERD(0, 1.0f, 4.0f, 1.0f, 1.5f, 0.6f, 1, 2, 3.2f),
        BATTLEAXE(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.5f, 1, 2, 3.0f),
        WARHAMMER(0, 1.0f, 4.0f, 1.0f, 1.0f, 0.7f, 1, 2, 3.0f),
        KNIFE(0, 0.5f, 3.0f, 1.0f, 1.5f, 0.2f, 1, 2, 2.0f),
        KATANA(0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1, 2, 0.2f),
        FIREROD(1, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 2, 0, 0.0f),
        BOOMERANG(0, 0.5f, 2.0f, 1.0f, 1.0f, 0.4f, 1, 1, 2.0f),
        NONE(0, 1.0f, 1.0f, 0.0f, 1.0f, 0.4f, 0, 0, 0.0f);

        public final int durabilityBase;
        public final float durabilityMult;
        public final float damageBase;
        public final float damageMult;
        public final float blockDamage;
        public final float knockback;
        public final float attackDelay;
        public final int dmgFromEntity;
        public final int dmgFromBlock;

        private MeleeSpecs(int durbase, float durmult, float dmgbase, float dmgmult, float blockdmg, float knockbck, int dmgfromentity, int dmgfromblock, float attackdelay) {
            this.durabilityBase = durbase;
            this.durabilityMult = durmult;
            this.damageBase = dmgbase;
            this.damageMult = dmgmult;
            this.blockDamage = blockdmg;
            this.knockback = knockbck;
            this.dmgFromEntity = dmgfromentity;
            this.dmgFromBlock = dmgfromblock;
            this.attackDelay = attackdelay;
        }

        public float getKnockBack(ToolMaterial material) {
            return material == ToolMaterial.GOLD ? this.knockback * 1.5f : this.knockback;
        }
    }
}

