/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.item.MeleeCompHalberd;
import ckathode.weaponmod.item.RangedComponent;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperties;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class WMItemProperties {
    public static final ResourceLocation RELOAD_GETTER_ID = BalkonsWeaponMod.id("reload");
    public static final ResourceLocation RELOADED_GETTER_ID = BalkonsWeaponMod.id("reloaded");
    public static final ResourceLocation FLAIL_THROWN_GETTER_ID = BalkonsWeaponMod.id("flail-thrown");
    public static final ResourceLocation HALBERD_STATE_GETTER_ID = BalkonsWeaponMod.id("halberd-state");

    private WMItemProperties() {
        throw new UnsupportedOperationException();
    }

    public static void init() {
        ConditionalItemModelProperties.ID_MAPPER.put((Object)RELOAD_GETTER_ID, Reload.MAP_CODEC);
        ConditionalItemModelProperties.ID_MAPPER.put((Object)RELOADED_GETTER_ID, Reloaded.MAP_CODEC);
        ConditionalItemModelProperties.ID_MAPPER.put((Object)FLAIL_THROWN_GETTER_ID, FlailThrown.MAP_CODEC);
        ConditionalItemModelProperties.ID_MAPPER.put((Object)HALBERD_STATE_GETTER_ID, HalberdState.MAP_CODEC);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Reload() implements ConditionalItemModelProperty
    {
        public static final MapCodec<Reload> MAP_CODEC = MapCodec.unit((Object)new Reload());

        public boolean get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            return livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack && !RangedComponent.isReloaded(itemStack);
        }

        @NotNull
        public MapCodec<Reload> type() {
            return MAP_CODEC;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Reloaded() implements ConditionalItemModelProperty
    {
        public static final MapCodec<Reloaded> MAP_CODEC = MapCodec.unit((Object)new Reloaded());

        public boolean get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            return RangedComponent.isReloaded(itemStack);
        }

        @NotNull
        public MapCodec<Reloaded> type() {
            return MAP_CODEC;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record FlailThrown() implements ConditionalItemModelProperty
    {
        public static final MapCodec<FlailThrown> MAP_CODEC = MapCodec.unit((Object)new FlailThrown());

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            if (!(livingEntity instanceof Player)) return false;
            Player player = (Player)livingEntity;
            if (livingEntity.getMainHandItem() != itemStack) return false;
            if (!PlayerWeaponData.isFlailThrown(player)) return false;
            return true;
        }

        @NotNull
        public MapCodec<FlailThrown> type() {
            return MAP_CODEC;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record HalberdState() implements ConditionalItemModelProperty
    {
        public static final MapCodec<HalberdState> MAP_CODEC = MapCodec.unit((Object)new HalberdState());

        public boolean get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            return MeleeCompHalberd.getHalberdState(itemStack);
        }

        @NotNull
        public MapCodec<HalberdState> type() {
            return MAP_CODEC;
        }
    }
}

