/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.network.MsgCannonFire;
import ckathode.weaponmod.network.MsgExplosion;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class WMMessagePipeline {
    public static void sendTo(@NotNull CustomPacketPayload message, @NotNull ServerPlayer player) {
        if (NetworkManager.canPlayerReceive((ServerPlayer)player, (CustomPacketPayload.Type)message.type())) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message);
        }
    }

    public static void sendToAround(@NotNull CustomPacketPayload message, @NotNull ServerLevel level, double x, double y, double z, double radius, ResourceKey<Level> dimension) {
        for (ServerPlayer player : level.getServer().getPlayerList().getPlayers()) {
            double f;
            double e;
            double d;
            if (player.level().dimension() != dimension || !((d = x - player.getX()) * d + (e = y - player.getY()) * e + (f = z - player.getZ()) * f < radius * radius)) continue;
            WMMessagePipeline.sendTo(message, player);
        }
    }

    public static void sendToServer(@NotNull CustomPacketPayload message) {
        if (NetworkManager.canServerReceive((CustomPacketPayload.Type)message.type())) {
            NetworkManager.sendToServer((CustomPacketPayload)message);
        }
    }

    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), MsgCannonFire.CANNON_FIRE_PACKET_TYPE, MsgCannonFire.STREAM_CODEC, MsgCannonFire::handleServerSide);
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), MsgExplosion.EXPLOSION_PACKET_TYPE, MsgExplosion.STREAM_CODEC, MsgExplosion::handleClientSide);
        } else {
            NetworkManager.registerS2CPayloadType(MsgExplosion.EXPLOSION_PACKET_TYPE, MsgExplosion.STREAM_CODEC);
        }
    }
}

