/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiOverlayReloaded {
    public static void renderGUIOverlay(GuiGraphics guiGraphics) {
        if (!WeaponModConfig.get().guiOverlayReloaded) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer p = mc.player;
        if (p == null) {
            return;
        }
        GuiOverlayReloaded.renderForHand(InteractionHand.MAIN_HAND, (Player)p, guiGraphics);
        GuiOverlayReloaded.renderForHand(InteractionHand.OFF_HAND, (Player)p, guiGraphics);
    }

    private static void renderForHand(InteractionHand hand, Player p, GuiGraphics guiGraphics) {
        Item item;
        ItemStack is;
        int currentItem = p.getInventory().getSelectedSlot();
        IItemWeapon item2 = null;
        ItemStack itemStack = is = hand == InteractionHand.OFF_HAND ? p.getOffhandItem() : p.getInventory().getItem(currentItem);
        if (!is.isEmpty() && (item = is.getItem()) instanceof IItemWeapon) {
            IItemWeapon iiw;
            item2 = iiw = (IItemWeapon)item;
        }
        if (item2 == null) {
            return;
        }
        RangedComponent rc = item2.getRangedComponent();
        MeleeComponent mec = item2.getMeleeComponent();
        boolean set = false;
        float f = 0.0f;
        int offset = 0;
        if (rc != null) {
            if (p.getUsedItemHand() == hand) {
                if (RangedComponent.isReloaded(is)) {
                    f = 1.0f;
                    offset = RangedComponent.isReadyToFire(is) ? 48 : 24;
                } else {
                    f = Mth.clamp((float)((float)p.getTicksUsingItem() / (float)rc.getReloadDuration(is)), (float)0.0f, (float)1.0f);
                }
                set = true;
            }
        } else if (mec != null && mec.shouldRenderCooldown()) {
            f = Mth.clamp((float)mec.getCooldown(), (float)0.0f, (float)1.0f);
            set = true;
        }
        if (!set) {
            return;
        }
        HumanoidArm offHandSide = p.getMainArm().getOpposite();
        int x0 = guiGraphics.guiWidth() / 2 + (hand == InteractionHand.OFF_HAND ? (offHandSide == HumanoidArm.LEFT ? -120 : 91) : -92 + currentItem * 20);
        int y0 = guiGraphics.guiHeight() + 1;
        int tx = hand == InteractionHand.OFF_HAND ? (offHandSide == HumanoidArm.LEFT ? 24 : 53) : 0;
        int width = hand == InteractionHand.OFF_HAND ? 29 : 24;
        int height = (int)(f * 24.0f);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -90.0f);
        guiGraphics.blit(RenderType::guiTextured, WeaponModResources.Gui.OVERLAY, x0, y0 - height, (float)tx, (float)(offset + 24 - height), width, height, 256, 256);
        guiGraphics.pose().popPose();
    }
}

