/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.projectile.EntityCrossbowBolt;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class RenderCrossbowBolt
extends WMRenderer<EntityCrossbowBolt, CrossbowBoltRenderState> {
    public RenderCrossbowBolt(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CrossbowBoltRenderState entityRenderState, PoseStack ms, MultiBufferSource bufs, int lm) {
        VertexConsumer builder = bufs.getBuffer(RenderType.entityCutout((ResourceLocation)WeaponModResources.Entity.BOLT));
        ms.pushPose();
        ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(entityRenderState.yRot - 90.0f));
        ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(entityRenderState.xRot));
        float f11 = entityRenderState.shakeTime;
        if (f11 > 0.0f) {
            float f12 = -Mth.sin((float)(f11 * 3.0f)) * f11;
            ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f12));
        }
        ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
        ms.scale(0.05625f, 0.05625f, 0.05625f);
        ms.translate(-1.0f, 0.0f, 0.0f);
        PoseStack.Pose last = ms.last();
        this.drawVertex(last, builder, -5.0f, -2.0f, -2.0f, 0.0f, 0.15625f, 0.05625f, 0.0f, 0.0f, lm);
        this.drawVertex(last, builder, -5.0f, -2.0f, 2.0f, 0.15625f, 0.15625f, 0.05625f, 0.0f, 0.0f, lm);
        this.drawVertex(last, builder, -5.0f, 2.0f, 2.0f, 0.15625f, 0.3125f, 0.05625f, 0.0f, 0.0f, lm);
        this.drawVertex(last, builder, -5.0f, 2.0f, -2.0f, 0.0f, 0.3125f, 0.05625f, 0.0f, 0.0f, lm);
        this.drawVertex(last, builder, -5.0f, 2.0f, -2.0f, 0.0f, 0.15625f, -0.05625f, 0.0f, 0.0f, lm);
        this.drawVertex(last, builder, -5.0f, 2.0f, 2.0f, 0.15625f, 0.15625f, -0.05625f, 0.0f, 0.0f, lm);
        this.drawVertex(last, builder, -5.0f, -2.0f, 2.0f, 0.15625f, 0.3125f, -0.05625f, 0.0f, 0.0f, lm);
        this.drawVertex(last, builder, -5.0f, -2.0f, -2.0f, 0.0f, 0.3125f, -0.05625f, 0.0f, 0.0f, lm);
        for (int j = 0; j < 4; ++j) {
            ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            last = ms.last();
            this.drawVertex(last, builder, -6.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
            this.drawVertex(last, builder, 6.0f, -2.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
            this.drawVertex(last, builder, 6.0f, 2.0f, 0.0f, 0.5f, 0.15625f, 0.0f, 0.0f, 0.05625f, lm);
            this.drawVertex(last, builder, -6.0f, 2.0f, 0.0f, 0.0f, 0.15625f, 0.0f, 0.0f, 0.05625f, lm);
        }
        ms.popPose();
        super.render((EntityRenderState)entityRenderState, ms, bufs, lm);
    }

    @NotNull
    public CrossbowBoltRenderState createRenderState() {
        return new CrossbowBoltRenderState();
    }

    @Override
    public void extractRenderState(EntityCrossbowBolt entity, CrossbowBoltRenderState entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        entityRenderState.shakeTime = (float)entity.shakeTime - f;
    }

    public static class CrossbowBoltRenderState
    extends WMRenderer.WMRendererState {
        public float shakeTime;
    }
}

