/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.projectile.EntitySpear;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class RenderSpear
extends WMRenderer<EntitySpear, SpearRenderState> {
    public RenderSpear(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SpearRenderState entityRenderState, PoseStack ms, MultiBufferSource bufs, int lm) {
        if (!WeaponModConfig.get().itemModelForEntity) {
            VertexConsumer builder = bufs.getBuffer(RenderType.entityCutout((ResourceLocation)WeaponModResources.Entity.SPEAR));
            ms.pushPose();
            ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(entityRenderState.yRot - 90.0f));
            ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(entityRenderState.xRot));
            float[] color = entityRenderState.materialColor;
            float length = 20.0f;
            float f13 = entityRenderState.shakeTime;
            if (f13 > 0.0f) {
                float f14 = -Mth.sin((float)(f13 * 3.0f)) * f13;
                ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f14));
            }
            ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
            ms.scale(0.05625f, 0.05625f, 0.05625f);
            ms.translate(-4.0f, 0.0f, 0.0f);
            PoseStack.Pose last = ms.last();
            this.drawVertex(last, builder, -length, -2.0f, -2.0f, 0.0f, 0.15625f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, -2.0f, 2.0f, 0.15625f, 0.15625f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, 2.0f, 0.15625f, 0.3125f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, -2.0f, 0.0f, 0.3125f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, -2.0f, 0.0f, 0.15625f, -0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, 2.0f, 0.15625f, 0.15625f, -0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, -2.0f, 2.0f, 0.15625f, 0.3125f, -0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, -2.0f, -2.0f, 0.0f, 0.3125f, -0.05625f, 0.0f, 0.0f, lm);
            for (int j = 0; j < 4; ++j) {
                ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                last = ms.last();
                this.drawVertex(last, builder, -length, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, length, -2.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, length, 2.0f, 0.0f, 1.0f, 0.15625f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, -length, 2.0f, 0.0f, 0.0f, 0.15625f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, -length, -2.0f, 0.0f, color[0], color[1], color[2], 1.0f, 0.0f, 0.3125f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, length, -2.0f, 0.0f, color[0], color[1], color[2], 1.0f, 1.0f, 0.3125f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, length, 2.0f, 0.0f, color[0], color[1], color[2], 1.0f, 1.0f, 0.46875f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, -length, 2.0f, 0.0f, color[0], color[1], color[2], 1.0f, 0.0f, 0.46875f, 0.0f, 0.0f, 0.05625f, lm);
            }
            ms.popPose();
        } else {
            ItemRenderer itemRender = Minecraft.getInstance().getItemRenderer();
            ms.pushPose();
            ms.scale(1.7f, 1.7f, 1.7f);
            ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(entityRenderState.yRot - 90.0f));
            ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(entityRenderState.xRot - 45.0f));
            float f15 = entityRenderState.shakeTime;
            if (f15 > 0.0f) {
                float f16 = -Mth.sin((float)(f15 * 3.0f)) * f15;
                ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f16));
            }
            ms.translate(-0.35f, -0.35f, 0.0f);
            itemRender.renderStatic(entityRenderState.weapon, ItemDisplayContext.NONE, lm, OverlayTexture.NO_OVERLAY, ms, bufs, (Level)Minecraft.getInstance().level, 0);
            ms.popPose();
        }
        super.render((EntityRenderState)entityRenderState, ms, bufs, lm);
    }

    @NotNull
    public SpearRenderState createRenderState() {
        return new SpearRenderState();
    }

    @Override
    public void extractRenderState(EntitySpear entity, SpearRenderState entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        entityRenderState.shakeTime = (float)entity.shakeTime - f;
        entityRenderState.weaponMaterialId = entity.getWeaponMaterialId();
        entityRenderState.materialColor = entity.getMaterialColor();
        entityRenderState.weapon = entity.getWeapon();
    }

    public static class SpearRenderState
    extends WMRenderer.WMRendererState {
        public float shakeTime;
        public int weaponMaterialId;
        public float[] materialColor;
        public ItemStack weapon;
    }
}

