/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class AdvancedExplosion
extends Explosion {
    protected static final Random rand = new Random();
    public final World worldObj;
    public final double explosionX;
    public final double explosionY;
    public final double explosionZ;
    public final Entity exploder;
    public final float explosionSize;
    protected boolean blocksCalculated;
    public final boolean isFlaming;
    public final boolean isSmoking;

    public AdvancedExplosion(World world, Entity entity, double x, double y, double z, float size, boolean flame, boolean smoke) {
        super(world, entity, x, y, z, size);
        this.worldObj = world;
        this.exploder = entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = size;
        this.isFlaming = flame;
        this.isSmoking = smoke;
    }

    public void setAffectedBlockPositions(List<ChunkPosition> list) {
        this.field_77281_g = list;
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(DamageSource.func_94539_a((Explosion)this));
    }

    public void doEntityExplosion(DamageSource damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)size - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)size + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)size - 1.0));
        int i3 = MathHelper.func_76128_c((double)(this.explosionY + (double)size + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)size - 1.0));
        int j3 = MathHelper.func_76128_c((double)(this.explosionZ + (double)size + 1.0));
        List list = this.worldObj.func_72839_b(this.exploder, AxisAlignedBB.func_72330_a((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        Vec3 vec31 = Vec3.func_72443_a((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (Entity entity : list) {
            double dz;
            double dy;
            double dx;
            double d;
            double dr = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)size;
            if (!(dr <= 1.0) || (d = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - this.explosionX) * dx + (dy = entity.field_70163_u - this.explosionY) * dy + (dz = entity.field_70161_v - this.explosionZ) * dz))) == 0.0) continue;
            dx /= d;
            dy /= d;
            dz /= d;
            double dens = this.worldObj.func_72842_a(vec31, EntityProjectile.getBoundingBox(entity));
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.func_70097_a(damagesource, (float)damage);
            entity.field_70159_w += dx * var36;
            entity.field_70181_x += dy * var36;
            entity.field_70179_y += dz * var36;
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (ChunkPosition blockpos : this.field_77281_g) {
            int x = blockpos.field_151329_a;
            int y = blockpos.field_151327_b;
            int z = blockpos.field_151328_c;
            Block block = this.worldObj.func_147439_a(x, y, z);
            if (this.worldObj.func_147437_c(x, y, z) || block == null) continue;
            if (block.func_149659_a((Explosion)this)) {
                block.func_149690_a(this.worldObj, x, y, z, this.worldObj.func_72805_g(x, y, z), 1.0f / this.explosionSize, 0);
            }
            this.worldObj.func_147468_f(x, y, z);
            block.func_149723_a(this.worldObj, x, y, z, (Explosion)this);
        }
    }

    public void doFlaming() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (ChunkPosition blockpos : this.field_77281_g) {
            int x = blockpos.field_151329_a;
            int y = blockpos.field_151327_b;
            int z = blockpos.field_151328_c;
            if (!this.worldObj.func_147437_c(x, y, z) || this.worldObj.func_147437_c(x, y - 1, z) || !this.worldObj.func_147439_a(x, y - 1, z).func_149730_j() || rand.nextInt(3) != 0) continue;
            this.worldObj.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        this.worldObj.func_72908_a(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (bigparticles) {
            this.worldObj.func_72869_a("hugeexplosion", this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0);
        }
        if (!smallparticles) {
            return;
        }
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (ChunkPosition blockpos : this.field_77281_g) {
            double px = (float)blockpos.field_151329_a + this.worldObj.field_73012_v.nextFloat();
            double py = (float)blockpos.field_151327_b + this.worldObj.field_73012_v.nextFloat();
            double pz = (float)blockpos.field_151328_c + this.worldObj.field_73012_v.nextFloat();
            double dx = px - this.explosionX;
            double dy = py - this.explosionY;
            double dz = pz - this.explosionZ;
            double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)this.explosionSize + 0.1);
            this.worldObj.func_72869_a("explode", (px + this.explosionX) / 2.0, (py + this.explosionY) / 2.0, (pz + this.explosionZ) / 2.0, dx *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), dy *= d7, dz *= d7);
            this.worldObj.func_72869_a("smoke", px, py, pz, dx, dy, dz);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < maxsize; ++j) {
            for (int k = 0; k < maxsize; ++k) {
                for (int l = 0; l < maxsize; ++l) {
                    if (j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1 && l != 0 && l != maxsize - 1) continue;
                    double rx = (float)j / 15.0f * 2.0f - 1.0f;
                    double ry = (float)k / 15.0f * 2.0f - 1.0f;
                    double rz = (float)l / 15.0f * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.explosionX;
                    double dy = this.explosionY;
                    double dz = this.explosionZ;
                    float f = 0.3f;
                    for (float strength = this.explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); strength > 0.0f; strength -= 0.22500001f) {
                        int x = MathHelper.func_76128_c((double)dx);
                        int y = MathHelper.func_76128_c((double)dy);
                        int z = MathHelper.func_76128_c((double)dz);
                        Block block = this.worldObj.func_147439_a(x, y, z);
                        if (!this.worldObj.func_147437_c(x, y, z) && block != null) {
                            strength -= (block.getExplosionResistance(this.exploder, this.worldObj, x, y, z, this.explosionX, this.explosionY, this.explosionZ) + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(new ChunkPosition(x, y, z));
                        }
                        dx += rx * 0.3;
                        dy += ry * 0.3;
                        dz += rz * 0.3;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        this.blocksCalculated = true;
    }
}

