/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.BalkonsWeaponMod;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.player.EntityPlayer;

public final class PlayerWeaponData {
    private static final int WARHAMMER_LAST_SMASH_TICKS = BalkonsWeaponMod.instance.modConfig.getDataWatcherId("warhammer_last_smash_ticks");
    private static final int FLAIL_THROWN = BalkonsWeaponMod.instance.modConfig.getDataWatcherId("flail_thrown");
    private static final int FLAIL_ENTITY_ID = BalkonsWeaponMod.instance.modConfig.getDataWatcherId("flail_entity_id");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPlayerWeaponData(EntityPlayer player) {
        String playername = PlayerWeaponData.getPlayerName(player);
        BalkonsWeaponMod.modLog.trace("Initializing DataManager values for {}", new Object[]{playername});
        DataWatcher dataWatcher = player.func_70096_w();
        try {
            dataWatcher.func_75679_c(WARHAMMER_LAST_SMASH_TICKS);
            BalkonsWeaponMod.modLog.warn("DataManager ID conflict for {} @ {}", new Object[]{playername, WARHAMMER_LAST_SMASH_TICKS});
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataWatcher.func_75682_a(WARHAMMER_LAST_SMASH_TICKS, (Object)player.field_70173_aa);
        }
        try {
            dataWatcher.func_75679_c(FLAIL_THROWN);
            BalkonsWeaponMod.modLog.warn("DataManager ID conflict for {} @ {}", new Object[]{playername, FLAIL_THROWN});
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataWatcher.func_75682_a(FLAIL_THROWN, (Object)0);
        }
        try {
            dataWatcher.func_75679_c(FLAIL_ENTITY_ID);
            BalkonsWeaponMod.modLog.warn("DataManager ID conflict for {} @ {}", new Object[]{playername, FLAIL_ENTITY_ID});
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataWatcher.func_75682_a(FLAIL_ENTITY_ID, (Object)0);
        }
    }

    private static String getPlayerName(EntityPlayer player) {
        String playername = player.func_146103_bH() != null ? player.func_146103_bH().getName() : "[unknown]";
        return "player:" + playername;
    }

    private static void unavailableError(EntityPlayer player, int id) {
        BalkonsWeaponMod.modLog.error("DataManager ID {} for {} unavailable, trying to reinitialize", new Object[]{id, PlayerWeaponData.getPlayerName(player)});
        PlayerWeaponData.initPlayerWeaponData(player);
    }

    public static int getLastWarhammerSmashTicks(EntityPlayer player) {
        try {
            return player.func_70096_w().func_75679_c(WARHAMMER_LAST_SMASH_TICKS);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS);
            return 0;
        }
    }

    public static void setLastWarhammerSmashTicks(EntityPlayer player, int age) {
        try {
            player.func_70096_w().func_75692_b(WARHAMMER_LAST_SMASH_TICKS, (Object)age);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS);
        }
    }

    public static boolean isFlailThrown(EntityPlayer player) {
        try {
            return player.func_70096_w().func_75679_c(FLAIL_THROWN) == 1;
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN);
            return false;
        }
    }

    public static void setFlailThrown(EntityPlayer player, boolean flag) {
        try {
            player.func_70096_w().func_75692_b(FLAIL_THROWN, (Object)(flag ? 1 : 0));
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN);
        }
    }

    public static int getFlailEntityId(EntityPlayer player) {
        try {
            return player.func_70096_w().func_75679_c(FLAIL_ENTITY_ID);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID);
            return 0;
        }
    }

    public static void setFlailEntityId(EntityPlayer player, int id) {
        try {
            player.func_70096_w().func_75692_b(FLAIL_ENTITY_ID, (Object)id);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID);
        }
    }
}

