/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import cpw.mods.fml.client.IModGuiFactory;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;

public class WeaponModConfig {
    private static final String CATEGORY_SETTINGS = "settings";
    private static final String CATEGORY_ENABLE = "enable";
    private static final String CATEGORY_RELOADTIME = "reloadtime";
    private static final String CATEGORY_DATAWATCHER = "datawatcher";
    private static WeaponModConfig instance;
    private final Configuration config;
    public boolean cannonDoesBlockDamage;
    public boolean dynamiteDoesBlockDamage;
    public boolean mortarDoesBlockDamage;
    public boolean canThrowKnife;
    public boolean canThrowSpear;
    public boolean allCanPickup;
    public boolean guiOverlayReloaded;
    public boolean itemModelForEntity;
    public boolean legacyCannonModel;
    private final Map<String, EnableSetting> enableSettings;
    private final Map<String, ReloadTimeSetting> reloadTimeSettings;
    private final Map<String, DataWatcherIdSetting> dataWatcherIds;

    public WeaponModConfig(Configuration configuration) {
        instance = this;
        this.config = configuration;
        this.enableSettings = new LinkedHashMap<String, EnableSetting>();
        this.reloadTimeSettings = new LinkedHashMap<String, ReloadTimeSetting>();
        this.dataWatcherIds = new LinkedHashMap<String, DataWatcherIdSetting>();
    }

    public void addEnableSetting(String weapon) {
        this.enableSettings.put(weapon, new EnableSetting(weapon, true));
    }

    public void addReloadTimeSetting(String weapon, int defaulttime) {
        this.reloadTimeSettings.put(weapon, new ReloadTimeSetting(weapon, defaulttime));
    }

    public void addDataWatcherIdSetting(String desc, int defaultId) {
        this.dataWatcherIds.put(desc, new DataWatcherIdSetting(desc, defaultId));
    }

    public boolean isEnabled(String weapon) {
        EnableSetting es = this.enableSettings.get(weapon);
        return es == null || es.enabled;
    }

    public int getReloadTime(String weapon) {
        ReloadTimeSetting rs = this.reloadTimeSettings.get(weapon);
        return rs == null ? 0 : rs.reloadTime;
    }

    public int getDataWatcherId(String desc) {
        DataWatcherIdSetting ds = this.dataWatcherIds.get(desc);
        return ds == null ? 0 : ds.id;
    }

    public void init() {
        this.syncConfig(true);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void syncConfig(boolean load) {
        if (load) {
            this.config.load();
        }
        this.config.addCustomCategoryComment(CATEGORY_SETTINGS, "Miscellaneous mod settings");
        this.config.addCustomCategoryComment(CATEGORY_ENABLE, "Enable or disable certain weapons (only disables their recipes; they are still obtainable through Creative mode!)");
        this.config.addCustomCategoryComment(CATEGORY_RELOADTIME, "The reload durations of the reloadable weapons");
        this.config.addCustomCategoryComment(CATEGORY_DATAWATCHER, "Data Watcher IDs - if your game crashes because there is a conflict with another mod's Data Watcher entries, you can fix it here by changing the ID(s)!");
        this.config.setCategoryRequiresMcRestart(CATEGORY_ENABLE, true);
        this.config.setCategoryRequiresWorldRestart(CATEGORY_ENABLE, true);
        this.config.setCategoryRequiresMcRestart(CATEGORY_RELOADTIME, true);
        this.config.setCategoryRequiresWorldRestart(CATEGORY_RELOADTIME, true);
        this.config.setCategoryRequiresMcRestart(CATEGORY_DATAWATCHER, true);
        this.config.setCategoryRequiresWorldRestart(CATEGORY_DATAWATCHER, true);
        this.cannonDoesBlockDamage = this.config.get(CATEGORY_SETTINGS, "cannon-block-damage", true).getBoolean(true);
        this.dynamiteDoesBlockDamage = this.config.get(CATEGORY_SETTINGS, "dynamite-block-damage", true).getBoolean(true);
        this.mortarDoesBlockDamage = this.config.get(CATEGORY_SETTINGS, "mortar-block-damage", true).getBoolean(true);
        this.canThrowKnife = this.config.get(CATEGORY_SETTINGS, "can-throw-knife", true).getBoolean(true);
        this.canThrowSpear = this.config.get(CATEGORY_SETTINGS, "can-throw-spear", true).getBoolean(true);
        this.allCanPickup = this.config.get(CATEGORY_SETTINGS, "pickup-all", true, "Change this to 'false' to allow only the thrower/shooter of the projectile to pick the item up. If set to 'true' everyone can pick the item up.").getBoolean(true);
        this.guiOverlayReloaded = this.config.get(CATEGORY_SETTINGS, "reload-progress", true, "Show reload progress in hotbar.").getBoolean(true);
        this.itemModelForEntity = this.config.get(CATEGORY_SETTINGS, "render-entity-model", true, "Item model for entity (knife, spear, etc).").getBoolean(true);
        this.legacyCannonModel = this.config.get(CATEGORY_SETTINGS, "legacy-cannon-model", false, "Changes the cannon to the legacy model from older versions of BWM!").getBoolean(true);
        for (EnableSetting es : this.enableSettings.values()) {
            es.enabled = this.config.get(CATEGORY_ENABLE, es.settingName, es.enabled).getBoolean(es.enabled);
        }
        for (ReloadTimeSetting rs : this.reloadTimeSettings.values()) {
            rs.reloadTime = this.config.get(CATEGORY_RELOADTIME, rs.settingName, rs.reloadTime).getInt(rs.reloadTime);
        }
        for (DataWatcherIdSetting ds : this.dataWatcherIds.values()) {
            ds.id = this.config.get(CATEGORY_DATAWATCHER, ds.settingName, ds.id).getInt(ds.id);
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if ("weaponmod".equals(e.modID)) {
            this.syncConfig(false);
        }
    }

    public static class WMGUIConfig
    extends GuiConfig {
        public WMGUIConfig(GuiScreen parentScreen) {
            this(instance.config, parentScreen);
        }

        public WMGUIConfig(Configuration config, GuiScreen parentScreen) {
            super(parentScreen, config.getCategoryNames().stream().sorted().map(c -> new ConfigElement(config.getCategory(c))).collect(Collectors.toList()), "weaponmod", false, false, "Balkon's WeaponMod: Legacy configuration");
        }
    }

    public static class GuiFactory
    implements IModGuiFactory {
        public void initialize(Minecraft minecraft) {
        }

        public Class<? extends GuiScreen> mainConfigGuiClass() {
            return WMGUIConfig.class;
        }

        public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
            return null;
        }

        public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement runtimeOptionCategoryElement) {
            return null;
        }
    }

    private static class DataWatcherIdSetting
    extends Setting {
        int id;

        DataWatcherIdSetting(String desc, int id) {
            super(desc);
            this.id = id;
        }
    }

    private static class EnableSetting
    extends Setting {
        boolean enabled;

        EnableSetting(String name, boolean enabled) {
            super(name + ".enabled");
            this.enabled = enabled;
        }
    }

    private static class ReloadTimeSetting
    extends Setting {
        int reloadTime;

        ReloadTimeSetting(String name, int time) {
            super(name + ".reloadtime");
            this.reloadTime = time;
        }
    }

    private static abstract class Setting {
        final String settingName;

        Setting(String name) {
            this.settingName = name;
        }
    }
}

