/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityDynamite
extends EntityProjectile {
    public static final String NAME = "dynamite";
    private int explodefuse;
    private boolean extinguished;

    public EntityDynamite(World world) {
        super(world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        this.extinguished = false;
        this.explodefuse = this.field_70146_Z.nextInt(30) + 20;
    }

    public EntityDynamite(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityDynamite(World world, EntityLivingBase shooter, int i) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.setThrower((Entity)shooter);
        this.explodefuse = i;
    }

    @Override
    public void setAim(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, f3, f4);
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.inGround && !this.beenInGround) {
            this.field_70125_A -= 50.0f;
            if (this.field_70125_A <= -360.0f) {
                this.field_70125_A += 360.0f;
            }
        } else {
            this.field_70125_A = this.field_70127_C = 180.0f;
        }
        if (this.func_70090_H() && !this.extinguished) {
            this.extinguished = true;
            this.field_70170_p.func_72956_a((Entity)this, "random.fizz", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            for (int k = 0; k < 8; ++k) {
                float f6 = 0.25f;
                this.field_70170_p.func_72869_a("explode", this.field_70165_t - this.field_70159_w * (double)f6, this.field_70163_u - this.field_70181_x * (double)f6, this.field_70161_v - this.field_70179_y * (double)f6, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
        --this.explodefuse;
        if (!this.extinguished) {
            if (this.explodefuse <= 0) {
                this.detonate();
                this.func_70106_y();
            } else {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onHitEntity(MovingObjectPosition mop) {
        Entity entity = mop.field_72308_g;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        if (entity.func_70097_a(damagesource, 1.0f)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.func_70016_h(0.0, 0.0, 0.0);
            this.ticksInAir = 0;
        }
    }

    @Override
    public void onHitBlock(MovingObjectPosition raytraceResult) {
        this.xTile = raytraceResult.field_72311_b;
        this.yTile = raytraceResult.field_72312_c;
        this.zTile = raytraceResult.field_72309_d;
        this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = raytraceResult.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = raytraceResult.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = raytraceResult.field_72307_f.field_72449_c - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.field_70159_w *= -0.2;
        this.field_70179_y *= -0.2;
        if (raytraceResult.field_72310_e == 1) {
            this.inGround = true;
            this.beenInGround = true;
        } else {
            this.inGround = false;
            this.field_70170_p.func_72956_a((Entity)this, "random.fizz", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        }
        if (this.inTile != null) {
            this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
    }

    private void detonate() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.extinguished && (this.ticksInGround >= 200 || this.ticksInAir >= 200)) {
            this.func_70106_y();
        }
        float f = 2.0f;
        PhysHelper.createAdvancedExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f, BalkonsWeaponMod.instance.modConfig.dynamiteDoesBlockDamage, true, false, false);
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @Nonnull
    public ItemStack getPickupItem() {
        return new ItemStack((Item)BalkonsWeaponMod.dynamite, 1);
    }

    @Override
    public void playHitSound() {
        this.field_70170_p.func_72956_a((Entity)this, "random.fizz", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74774_a("fuse", (byte)this.explodefuse);
        nbttagcompound.func_74757_a("off", this.extinguished);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.explodefuse = nbttagcompound.func_74771_c("fuse");
        this.extinguished = nbttagcompound.func_74767_n("off");
    }
}

