/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.entity.projectile.MaterialRegistry;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.ItemHitEffect;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityMaterialProjectile
extends EntityProjectile {
    private static final int WEAPON_MATERIAL = 18;
    private static final int WEAPON_ITEM = 19;
    private static final float[][] MATERIAL_COLORS = new float[][]{{0.6f, 0.4f, 0.1f}, {0.5f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f}, {0.0f, 0.8f, 0.7f}, {1.0f, 0.9f, 0.0f}};

    public EntityMaterialProjectile(World world) {
        super(world);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_82709_a(19, 5);
    }

    @Override
    public void writeSpawnData(ByteBuf buf) {
        super.writeSpawnData(buf);
        buf.writeInt(this.getWeaponMaterialId());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getWeapon());
    }

    @Override
    public void readSpawnData(ByteBuf buf) {
        super.readSpawnData(buf);
        this.field_70180_af.func_75692_b(18, (Object)buf.readInt());
        this.field_70180_af.func_75692_b(19, (Object)ByteBufUtils.readItemStack((ByteBuf)buf));
    }

    public float getMeleeHitDamage(Entity entity) {
        if (this.field_70250_c instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
            return EnchantmentHelper.func_77512_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (EntityLivingBase)((EntityLivingBase)entity));
        }
        return 0.0f;
    }

    @Override
    public void onHitEntity(MovingObjectPosition mop) {
        super.onHitEntity(mop);
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem != null && thrownItem.func_77973_b() instanceof ItemHitEffect) {
            ((ItemHitEffect)thrownItem.func_77973_b()).onHitEntity(this, mop);
        }
    }

    @Override
    public void onHitBlock(MovingObjectPosition raytraceResult) {
        super.onHitBlock(raytraceResult);
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem != null && thrownItem.func_77973_b() instanceof ItemHitEffect) {
            ((ItemHitEffect)thrownItem.func_77973_b()).onHitBlock(this, raytraceResult);
        }
    }

    @Override
    public void applyEntityHitEffects(Entity entity) {
        super.applyEntityHitEffects(entity);
        if (this.field_70250_c instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
            int i = EnchantmentHelper.func_77507_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (EntityLivingBase)((EntityLivingBase)entity));
            if (i != 0) {
                ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)i * 0.4f, (double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
            if ((i = EnchantmentHelper.func_90036_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c))) > 0 && !entity.func_70027_ad()) {
                entity.func_70015_d(1);
            }
        }
    }

    public void setThrownItemStack(@Nullable ItemStack itemstack) {
        this.field_70180_af.func_75692_b(19, (Object)itemstack);
        this.updateWeaponMaterial();
    }

    @Override
    @Nullable
    public ItemStack getPickupItem() {
        return this.getWeapon();
    }

    public int getWeaponMaterialId() {
        return this.field_70180_af.func_75679_c(18);
    }

    public ItemStack getWeapon() {
        return this.field_70180_af.func_82710_f(19);
    }

    protected void updateWeaponMaterial() {
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem != null && thrownItem.func_77973_b() instanceof IItemWeapon && ((IItemWeapon)thrownItem.func_77973_b()).getMeleeComponent() != null) {
            int material = MaterialRegistry.getMaterialID(thrownItem);
            if (material < 0) {
                material = ((IItemWeapon)thrownItem.func_77973_b()).getMeleeComponent().weaponMaterial.ordinal();
            }
            this.field_70180_af.func_75692_b(18, (Object)material);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getMaterialColor() {
        int id = this.getWeaponMaterialId();
        if (id >= 0 && id < MATERIAL_COLORS.length) {
            return MATERIAL_COLORS[id];
        }
        return MaterialRegistry.getColorFromMaterialID(id);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem != null) {
            nbttagcompound.func_74782_a("thrI", (NBTBase)thrownItem.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("thrI")) {
            this.setThrownItemStack(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("thrI")));
        }
    }
}

