/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemVariants;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeCompHalberd;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMelee
extends ItemSword
implements IItemWeapon {
    public final MeleeComponent meleeComponent;
    public final String rawId;
    private IIcon readyIcon;
    private IIcon halberdStateIcon;
    private Boolean readyIconExists;
    private Boolean halberdStateIconExists;

    public ItemMelee(String id, MeleeComponent meleecomponent) {
        this("weaponmod", id, meleecomponent);
    }

    public ItemMelee(String modId, String id, MeleeComponent meleecomponent) {
        super(meleecomponent.weaponMaterial == null ? Item.ToolMaterial.WOOD : meleecomponent.weaponMaterial);
        this.rawId = id;
        GameRegistry.registerItem((Item)this, (String)id, (String)modId);
        this.func_111206_d(modId + ":" + id);
        this.func_77655_b(id);
        this.meleeComponent = meleecomponent;
        this.meleeComponent.setItem(this);
        meleecomponent.setThisItemProperties();
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.readyIcon = null;
        this.halberdStateIcon = null;
        this.readyIconExists = null;
        this.halberdStateIconExists = null;
    }

    public float func_150931_i() {
        return this.meleeComponent.getEntityDamageMaterialPart();
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        return this.meleeComponent.getBlockDamage(itemstack, block);
    }

    public boolean func_150897_b(Block block) {
        return this.meleeComponent.canHarvestBlock(block);
    }

    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        return this.meleeComponent.hitEntity(itemstack, entityliving, attacker);
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase entityliving) {
        return this.meleeComponent.onBlockDestroyed(itemstack, world, block, x, y, z, entityliving);
    }

    public int func_77619_b() {
        return this.meleeComponent.getItemEnchantability();
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack itemstack) {
        return this.meleeComponent.getItemUseAction(itemstack);
    }

    public int func_77626_a(@Nonnull ItemStack itemstack) {
        return this.meleeComponent.getMaxItemUseDuration(itemstack);
    }

    @Override
    public boolean onLeftClickEntity(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer entityplayer) {
        return this.meleeComponent.onItemRightClick(world, entityplayer, stack);
    }

    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
        this.meleeComponent.onUsingTick(itemstack, (EntityLivingBase)entityplayer, count);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        this.meleeComponent.onPlayerStoppedUsing(itemstack, world, (EntityLivingBase)entityplayer, i);
    }

    public void func_77663_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull Entity entity, int i, boolean flag) {
        this.meleeComponent.onUpdate(itemstack, world, entity, i, flag);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        this.meleeComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        return multimap;
    }

    @Override
    public Random getItemRand() {
        return field_77697_d;
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return this.meleeComponent.shouldRotateAroundWhenRendering();
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (this.readyIconExists == null) {
            this.readyIconExists = WMItemVariants.itemVariantExists(this.readyIcon);
        }
        if (this.readyIconExists.booleanValue() && player != null && player.func_71039_bw()) {
            return this.readyIcon;
        }
        if (this.halberdStateIconExists == null) {
            this.halberdStateIconExists = WMItemVariants.itemVariantExists(this.halberdStateIcon);
        }
        if (this.halberdStateIconExists.booleanValue() && MeleeCompHalberd.getHalberdState(stack)) {
            return this.halberdStateIcon;
        }
        return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        List<IIcon> icons = WMItemVariants.registerItemVariants(register, (Item)this, "_ready", "_state");
        this.readyIcon = icons.get(0);
        this.halberdStateIcon = icons.get(1);
    }
}

