/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemVariants;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemShooter
extends ItemBow
implements IItemWeapon {
    protected static final int MAX_DELAY = 72000;
    public final RangedComponent rangedComponent;
    public final MeleeComponent meleeComponent;
    public final String rawId;
    private IIcon reloadIcon;
    private IIcon loadedIcon;
    private Boolean reloadIconExists;
    private Boolean loadedIconExists;

    public ItemShooter(String id, RangedComponent rangedcomponent, MeleeComponent meleecomponent) {
        this("weaponmod", id, rangedcomponent, meleecomponent);
    }

    public ItemShooter(String modId, String id, RangedComponent rangedcomponent, MeleeComponent meleecomponent) {
        this.rawId = id;
        GameRegistry.registerItem((Item)this, (String)id, (String)modId);
        this.func_111206_d(modId + ":" + id);
        this.func_77655_b(id);
        this.rangedComponent = rangedcomponent;
        this.meleeComponent = meleecomponent;
        rangedcomponent.setItem(this);
        meleecomponent.setItem(this);
        rangedcomponent.setThisItemProperties();
        this.reloadIcon = null;
        this.loadedIcon = null;
        this.reloadIconExists = null;
        this.loadedIconExists = null;
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        return this.meleeComponent.getBlockDamage(itemstack, block);
    }

    public boolean func_150897_b(Block block) {
        return this.meleeComponent.canHarvestBlock(block);
    }

    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        return this.meleeComponent.hitEntity(itemstack, entityliving, attacker);
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase entityliving) {
        return this.meleeComponent.onBlockDestroyed(itemstack, world, block, x, y, z, entityliving);
    }

    public int func_77619_b() {
        return this.meleeComponent.getItemEnchantability();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        this.meleeComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        this.rangedComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        return multimap;
    }

    @Override
    public boolean onLeftClickEntity(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity) && this.rangedComponent.onLeftClickEntity(itemstack, player, entity);
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack itemstack) {
        return this.rangedComponent.getItemUseAction(itemstack);
    }

    public int func_77626_a(@Nonnull ItemStack itemstack) {
        return this.rangedComponent.getMaxItemUseDuration(itemstack);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        return this.rangedComponent.onItemRightClick(worldIn, playerIn, itemStackIn);
    }

    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
        this.rangedComponent.onUsingTick(itemstack, (EntityLivingBase)entityplayer, count);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        this.rangedComponent.onPlayerStoppedUsing(itemstack, world, (EntityLivingBase)entityplayer, i);
    }

    public void func_77663_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull Entity entity, int i, boolean flag) {
        this.meleeComponent.onUpdate(itemstack, world, entity, i, flag);
        this.rangedComponent.onUpdate(itemstack, world, entity, i, flag);
    }

    @Override
    public Random getItemRand() {
        return field_77697_d;
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return this.rangedComponent;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return this.rangedComponent.shouldRotateAroundWhenRendering();
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (this.reloadIconExists == null) {
            this.reloadIconExists = WMItemVariants.itemVariantExists(this.reloadIcon);
        }
        if (this.reloadIconExists.booleanValue() && player != null && player.func_71039_bw() && !RangedComponent.isReloaded(stack)) {
            return this.reloadIcon;
        }
        if (this.loadedIconExists == null) {
            this.loadedIconExists = WMItemVariants.itemVariantExists(this.loadedIcon);
        }
        if (this.loadedIconExists.booleanValue() && RangedComponent.isReloaded(stack)) {
            return this.loadedIcon;
        }
        return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        List<IIcon> icons = WMItemVariants.registerItemVariants(register, (Item)this, "_reload", "-loaded");
        this.reloadIcon = icons.get(0);
        this.loadedIcon = icons.get(1);
    }
}

