/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WarhammerExplosion;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.WMItem;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class MeleeCompWarhammer
extends MeleeComponent {
    public static final int CHARGE_DELAY = 400;

    public MeleeCompWarhammer(Item.ToolMaterial toolmaterial) {
        super(MeleeComponent.MeleeSpecs.WARHAMMER, toolmaterial);
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, Block block) {
        float f = super.getBlockDamage(itemstack, block);
        float f2 = this.weaponMaterial.func_78000_c() + 2.0f;
        return f * f2;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityLivingBase entityliving, int i) {
        EntityPlayer entityplayer = (EntityPlayer)entityliving;
        int j = this.getMaxItemUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 4.0f) > 1.0f) {
            this.superSmash(itemstack, world, entityplayer);
        }
    }

    protected void superSmash(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.func_71038_i();
        float f = this.getEntityDamage() / 2.0f;
        WarhammerExplosion expl = new WarhammerExplosion(world, (Entity)entityplayer, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, f, false, true);
        expl.doEntityExplosion(DamageSource.func_76365_a((EntityPlayer)entityplayer));
        expl.doParticleExplosion(true, false);
        PhysHelper.sendExplosion(world, expl, true, false);
        itemstack.func_77972_a(16, (EntityLivingBase)entityplayer);
        if (itemstack.field_77994_a <= 0) {
            WMItem.deleteStack((IInventory)entityplayer.field_71071_by, itemstack);
        }
        entityplayer.func_71020_j(6.0f);
        this.setSmashed(entityplayer);
    }

    public void setSmashed(EntityPlayer entityplayer) {
        PlayerWeaponData.setLastWarhammerSmashTicks(entityplayer, entityplayer.field_70173_aa);
    }

    public boolean isCharged(EntityPlayer entityplayer) {
        return this.getCooldown(entityplayer) <= 0;
    }

    public float getScaledCooldown(EntityPlayer entityplayer) {
        return (float)this.getCooldown(entityplayer) / 400.0f;
    }

    public int getCooldown(EntityPlayer entityplayer) {
        return PlayerWeaponData.getLastWarhammerSmashTicks(entityplayer) + 400 - entityplayer.field_70173_aa;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.bow;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(World world, EntityPlayer entityplayer, ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0) {
            return itemstack;
        }
        if (this.isCharged(entityplayer)) {
            int i = this.getMaxItemUseDuration(itemstack);
            entityplayer.func_71008_a(itemstack, i);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderCooldown() {
        return !this.isCharged((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getCooldown() {
        return this.getScaledCooldown((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
    }
}

