/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.repackage.makamys.mclib.updatecheck;

import ckathode.weaponmod.repackage.makamys.mclib.core.MCLib;
import ckathode.weaponmod.repackage.makamys.mclib.updatecheck.ConfigUCL;
import ckathode.weaponmod.repackage.makamys.mclib.updatecheck.ResultHTMLRenderer;
import ckathode.weaponmod.repackage.makamys.mclib.updatecheck.UpdateCheckAPI;
import ckathode.weaponmod.repackage.makamys.mclib.updatecheck.UpdateCheckTask;
import ckathode.weaponmod.repackage.makamys.mclib.updatecheck.gui.GuiButtonUpdates;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateCheckLib {
    public static final String MODID = "UpdateCheckLib";
    public static final String VERSION = "0.3.7.7";
    public static final Logger LOGGER = LogManager.getLogger((String)"updatechecklib");
    private static UpdateCheckLib instance;
    private static BlockingQueue<Runnable> workQueue;
    static ThreadPoolExecutor executor;
    static List<CompletableFuture<UpdateCheckTask.Result>> futures;
    private static int updateCount;
    private static final File updatesFile;
    static UpdateCategory MODS;
    static UpdateCategory RESOURCE_PACKS;
    static Map<String, UpdateCategory> categories;
    private static final int UPDATES_BUTTON_ID = 1615486202;
    @SideOnly(value=Side.CLIENT)
    GuiButtonUpdates updatesButton;

    static boolean isEnabled() {
        ConfigUCL.loadIfNotAlready();
        return ConfigUCL.enabled;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiMainMenu) {
            ConfigUCL.reload();
            if (ConfigUCL.showUpdatesButton) {
                String url = null;
                try {
                    url = updatesFile.toURI().toURL().toString();
                }
                catch (MalformedURLException e) {
                    url = "";
                    e.printStackTrace();
                }
                int buttonX = ConfigUCL.updatesButtonX + (ConfigUCL.updatesButtonAbsolutePos ? 0 : event.gui.field_146294_l / 2);
                int buttonY = ConfigUCL.updatesButtonY + (ConfigUCL.updatesButtonAbsolutePos ? 0 : event.gui.field_146295_m / 4);
                this.updatesButton = new GuiButtonUpdates(1615486202, buttonX, buttonY, 20, 20, updateCount, url);
                event.buttonList.add(this.updatesButton);
            }
        } else {
            this.updatesButton = null;
        }
    }

    @Subscribe
    public void postInit(final FMLPostInitializationEvent event) {
        if (!UpdateCheckLib.isEnabled()) {
            return;
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(new Runnable(){

            @Override
            public void run() {
                List results = futures.stream().map(f -> {
                    try {
                        return (UpdateCheckTask.Result)f.get();
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to get retrieve update check result: " + e.getMessage());
                        return null;
                    }
                }).collect(Collectors.toList());
                updateCount = 0;
                for (UpdateCheckTask.Result result : results) {
                    if (result.foundUpdate()) {
                        updateCount++;
                    }
                    result.task.category.results.add(result);
                }
                UpdateCheckLib.this.onFinished();
                if (event.getSide() == Side.CLIENT) {
                    UpdateCheckLib.this.onFinishedClient();
                }
            }
        });
    }

    private void onFinished() {
        LOGGER.info("Found " + updateCount + " updates.");
        new ResultHTMLRenderer().render(updatesFile);
    }

    @SideOnly(value=Side.CLIENT)
    private void onFinishedClient() {
        if (this.updatesButton != null) {
            this.updatesButton.setUpdateCount(updateCount);
        }
    }

    static {
        workQueue = new LinkedBlockingQueue<Runnable>();
        executor = new ThreadPoolExecutor(0, 4, 60L, TimeUnit.SECONDS, workQueue);
        futures = new ArrayList<CompletableFuture<UpdateCheckTask.Result>>();
        updateCount = -1;
        updatesFile = new File(Launch.minecraftHome, "updates.html");
        MODS = new UpdateCategory(UpdateCheckAPI.MODS_CATEGORY_ID, "1.7.10", "Mod", false);
        RESOURCE_PACKS = new UpdateCategory(UpdateCheckAPI.RESOURCE_PACKS_CATEGORY_ID, "1.7.10", "Resource pack", false);
        categories = new HashMap<String, UpdateCategory>();
        instance = new UpdateCheckLib();
        MCLib.FML_MASTER.register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        categories.put(UpdateCheckAPI.MODS_CATEGORY_ID, MODS);
        categories.put(UpdateCheckAPI.RESOURCE_PACKS_CATEGORY_ID, RESOURCE_PACKS);
    }

    static class UpdateCategory
    implements Comparable<UpdateCategory> {
        public String id;
        public String displayName;
        public String version;
        public boolean backwardsCompatible;
        public List<UpdateCheckTask.Result> results = new ArrayList<UpdateCheckTask.Result>();

        public UpdateCategory(String id, String version, String displayName, boolean backwardsCompatible) {
            this.id = id;
            this.version = version;
            this.displayName = displayName;
            this.backwardsCompatible = backwardsCompatible;
        }

        @Override
        public int compareTo(UpdateCategory o) {
            return this.id.equals(UpdateCheckAPI.MODS_CATEGORY_ID) ? -1 : this.displayName.compareTo(o.displayName);
        }
    }
}

