/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.WMItem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RangedComponent
extends AbstractWeaponComponent {
    protected static final int MAX_DELAY = 72000;
    public final RangedSpecs rangedSpecs;

    public static boolean isReloaded(class_1799 itemstack) {
        return ReloadHelper.getReloadState(itemstack).isReloaded();
    }

    public static boolean isReadyToFire(class_1799 itemstack) {
        return ReloadHelper.getReloadState(itemstack) == ReloadHelper.ReloadState.STATE_READY;
    }

    public static void setReloadState(class_1799 itemstack, ReloadHelper.ReloadState state) {
        ReloadHelper.setReloadState(itemstack, state);
    }

    public RangedComponent(RangedSpecs rangedspecs) {
        this.rangedSpecs = rangedspecs;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public class_9285.class_9286 setAttributes(class_9285.class_9286 attributeBuilder) {
        attributeBuilder = attributeBuilder.method_57487(WMRegistries.RELOAD_TIME, new class_1322(WeaponModAttributes.RELOAD_TIME_ID, (double)this.rangedSpecs.getReloadTime(), class_1322.class_1323.field_6328), class_9274.field_49217);
        return attributeBuilder;
    }

    @Override
    public class_1792.class_1793 setProperties(class_1792.class_1793 properties) {
        return properties.method_7895(this.rangedSpecs.durability);
    }

    @Override
    public float getDamage() {
        return 0.0f;
    }

    @Override
    public float getEntityDamage() {
        return 0.0f;
    }

    @Override
    public boolean mineBlock(class_1799 itemstack, class_1937 world, class_2680 block, class_2338 pos, class_1309 entityliving) {
        return false;
    }

    @Override
    public void hurtEnemy(@NotNull class_1799 itemstack, @NotNull class_1309 entityliving, @NotNull class_1309 attacker) {
    }

    @Override
    public float getAttackDelay(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return 0.0f;
    }

    @Override
    public float getKnockBack(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return 0.0f;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public boolean onLeftClickEntity(class_1799 itemstack, class_1657 player, class_1297 entity) {
        return false;
    }

    @Override
    @NotNull
    public class_1839 getUseAnimation(class_1799 itemstack) {
        ReloadHelper.ReloadState state = ReloadHelper.getReloadState(itemstack);
        if (state == ReloadHelper.ReloadState.STATE_READY) {
            return class_1839.field_8953;
        }
        return class_1839.field_8952;
    }

    @Override
    public int getUseDuration(class_1799 itemstack) {
        return 72000;
    }

    @Override
    @NotNull
    public class_1269 use(class_1799 itemstack, class_1937 world, class_1657 entityplayer, class_1268 hand) {
        if (itemstack.method_7960() || entityplayer.method_6115()) {
            return class_1269.field_5814;
        }
        if (!this.hasAmmo(itemstack, world, entityplayer)) {
            this.soundEmpty(itemstack, world, entityplayer);
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
            return class_1269.field_5814;
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            this.soundCharge(itemstack, world, entityplayer);
            entityplayer.method_6019(hand);
            return class_1269.field_5812;
        }
        entityplayer.method_6019(hand);
        return class_1269.field_5812;
    }

    @Override
    public void onUsingTick(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        if (ReloadHelper.getReloadState(stack) == ReloadHelper.ReloadState.STATE_NONE && this.getUseDuration(stack) - remainingUseDuration >= this.getReloadDuration(stack)) {
            this.effectReloadDone(stack, livingEntity.method_37908(), livingEntity);
            RangedComponent.setReloadState(stack, ReloadHelper.ReloadState.STATE_RELOADED);
        }
    }

    @Override
    public boolean releaseUsing(class_1799 itemstack, class_1937 world, class_1309 entityliving, int i) {
        if (!RangedComponent.isReloaded(itemstack)) {
            return false;
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            if (this.hasAmmoAndConsume(itemstack, world, entityliving)) {
                this.fire(itemstack, world, entityliving, i);
            }
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        } else {
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_READY);
        }
        return true;
    }

    @Override
    public void inventoryTick(@NotNull class_1799 itemStack, @NotNull class_3218 serverLevel, @NotNull class_1297 entity, @Nullable class_1304 equipmentSlot) {
    }

    public void soundEmpty(class_1799 itemstack, class_1937 world, class_1657 entityplayer) {
        world.method_43128(null, entityplayer.method_23317(), entityplayer.method_23318(), entityplayer.method_23321(), class_3417.field_14762, class_3419.field_15248, 1.0f, 1.25f);
    }

    public void soundCharge(class_1799 itemstack, class_1937 world, class_1657 entityplayer) {
    }

    public void postShootingEffects(class_1799 itemstack, class_1309 entityLiving, class_1937 world) {
        if (entityLiving instanceof class_1657) {
            class_1657 entityplayer = (class_1657)entityLiving;
            this.effectPlayer(itemstack, entityplayer, world);
        }
        this.effectShoot(world, entityLiving.method_23317(), entityLiving.method_23318(), entityLiving.method_23321(), entityLiving.method_36454(), entityLiving.method_36455());
    }

    public abstract void effectReloadDone(class_1799 var1, class_1937 var2, class_1309 var3);

    public abstract void fire(class_1799 var1, class_1937 var2, class_1309 var3, int var4);

    public abstract void effectPlayer(class_1799 var1, class_1657 var2, class_1937 var3);

    public abstract void effectShoot(class_1937 var1, double var2, double var4, double var6, float var8, float var9);

    public void applyProjectileEnchantments(EntityProjectile<?> entity, class_1799 itemstack) {
        int damage;
        class_2378 enchRegistry = entity.method_56673().method_30530(class_7924.field_41265);
        class_6880 infinity = enchRegistry.method_46746(class_1893.field_9125).orElse(null);
        class_6880 power = enchRegistry.method_46746(class_1893.field_9103).orElse(null);
        class_6880 flame = enchRegistry.method_46746(class_1893.field_9126).orElse(null);
        if (infinity != null && class_1890.method_8225((class_6880)infinity, (class_1799)itemstack) > 0) {
            entity.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        }
        int n = damage = power == null ? 0 : class_1890.method_8225((class_6880)power, (class_1799)itemstack);
        if (damage > 0) {
            entity.setExtraDamage(damage);
        }
        if (flame != null && class_1890.method_8225((class_6880)flame, (class_1799)itemstack) > 0) {
            entity.method_5639(100.0f);
        }
    }

    public int getReloadDuration(class_1799 itemstack) {
        return this.rangedSpecs.getReloadTime();
    }

    public List<class_1792> getAmmoItems() {
        return this.rangedSpecs.getAmmoItems();
    }

    protected class_1799 findAmmo(class_1657 entityplayer) {
        class_3545<class_1304, Integer> slot = WMItem.findAnyItemSlot(entityplayer, this.getAmmoItems());
        if (slot == null) {
            return class_1799.field_8037;
        }
        return slot.method_15442() == class_1304.field_6173 ? entityplayer.method_31548().method_5438(((Integer)slot.method_15441()).intValue()) : entityplayer.method_6118((class_1304)slot.method_15442());
    }

    protected boolean consumeAmmo(class_1657 entityplayer) {
        return WMItem.consumeAnyInventoryItem(entityplayer, this.getAmmoItems());
    }

    public boolean hasAmmoAndConsume(class_1799 itemstack, class_1937 world, class_1309 entityliving) {
        if (!(entityliving instanceof class_1657)) {
            return true;
        }
        class_1657 entityplayer = (class_1657)entityliving;
        class_6880 infinity = entityplayer.method_56673().method_30530(class_7924.field_41265).method_46746(class_1893.field_9125).orElse(null);
        return entityplayer.method_68878() || infinity != null && class_1890.method_8225((class_6880)infinity, (class_1799)itemstack) > 0 || this.consumeAmmo(entityplayer);
    }

    public boolean hasAmmo(class_1799 itemstack, class_1937 world, class_1657 entityplayer) {
        class_6880 infinity = entityplayer.method_56673().method_30530(class_7924.field_41265).method_46746(class_1893.field_9125).orElse(null);
        boolean flag = !this.findAmmo(entityplayer).method_7960();
        return entityplayer.method_68878() || infinity != null && class_1890.method_8225((class_6880)infinity, (class_1799)itemstack) > 0 || flag;
    }

    public float getFOVMultiplier(int ticksInUse) {
        float f1 = (float)ticksInUse / this.getMaxAimTimeTicks();
        f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
        return 1.0f - f1 * this.getMaxZoom();
    }

    protected float getMaxAimTimeTicks() {
        return 20.0f;
    }

    protected float getMaxZoom() {
        return 0.15f;
    }

    public static enum RangedSpecs {
        BLOWGUN("blowgun", 250, (String[])Arrays.stream(DartType.dartTypes).filter(Objects::nonNull).map(t -> BalkonsWeaponMod.id(t.typeName()).toString()).toArray(String[]::new)),
        CROSSBOW("crossbow", 250, BalkonsWeaponMod.id("bolt").toString()),
        MUSKET("musket", 80, BalkonsWeaponMod.id("bullet").toString()),
        BLUNDERBUSS("blunderbuss", 80, BalkonsWeaponMod.id("shot").toString()),
        FLINTLOCK("flintlock", 8, BalkonsWeaponMod.id("bullet").toString()),
        MORTAR("mortar", 40, BalkonsWeaponMod.id("shell").toString());

        private int reloadTime;
        private List<class_1792> ammoItems;
        private final String[] ammoItemTags;
        public final String reloadTimeTag;
        public final int durability;

        private RangedSpecs(String reloadtimetag, int durability, String ... ammoitemtags) {
            this.ammoItemTags = ammoitemtags;
            this.reloadTimeTag = reloadtimetag;
            this.durability = durability;
            this.ammoItems = null;
            this.reloadTime = -1;
        }

        public int getReloadTime() {
            if (this.reloadTime < 0) {
                this.reloadTime = WeaponModConfig.get().getReloadTime(this.reloadTimeTag);
                BalkonsWeaponMod.LOGGER.debug("Found reload time {} for {} @{}", (Object)this.reloadTime, (Object)this.reloadTimeTag, (Object)this);
            }
            return this.reloadTime;
        }

        public List<class_1792> getAmmoItems() {
            if (this.ammoItems == null) {
                this.ammoItems = Arrays.stream(this.ammoItemTags).map(t -> (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)t))).collect(Collectors.toList());
                BalkonsWeaponMod.LOGGER.debug("Found items {} for {} @{}", this.ammoItems, (Object)Arrays.toString(this.ammoItemTags), (Object)this);
            }
            return this.ammoItems;
        }
    }
}

