/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.render.ModelCannonBarrel;
import ckathode.weaponmod.render.ModelCannonLegacy;
import ckathode.weaponmod.render.ModelCannonStandard;
import ckathode.weaponmod.render.WMRenderer;
import net.minecraft.class_10017;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class RenderCannon
extends WMRenderer<EntityCannon, CannonRenderState> {
    private final ModelCannonBarrel modelBarrel;
    private final ModelCannonStandard modelStandard;
    private final ModelCannonLegacy modelLegacy;

    public RenderCannon(class_5617.class_5618 context) {
        super(context);
        this.modelBarrel = new ModelCannonBarrel(context.method_32167(ModelCannonBarrel.CANNON_BARREL_LAYER));
        this.modelStandard = new ModelCannonStandard(context.method_32167(ModelCannonStandard.CANNON_STANDARD_LAYER));
        this.modelLegacy = new ModelCannonLegacy(context.method_32167(ModelCannonLegacy.CANNON_LEGACY_LAYER));
        this.field_4673 = 0.7f;
    }

    public void render(CannonRenderState entityRenderState, class_4587 ms, class_4597 bufs, int lm) {
        ms.method_22903();
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.method_22904(0.0, 0.1, 0.0);
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-entityRenderState.yRot));
        } else {
            ms.method_46416(0.0f, 2.375f, 0.0f);
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - entityRenderState.yRot));
        }
        float f2 = entityRenderState.hurtTime;
        float f3 = entityRenderState.currentDamage;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            ms.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)f2) * f2 * f3 / 10.0f * (float)entityRenderState.rockDirection / 5.0f));
        }
        int color = -3355444;
        if (entityRenderState.superPowered && entityRenderState.tickCount % 5 < 2) {
            color = -1;
        }
        if (WeaponModConfig.get().legacyCannonModel) {
            class_4588 builder = bufs.getBuffer(class_1921.method_23576((class_2960)WeaponModResources.Entity.CANNON_LEGACY));
            ms.method_22905(-1.0f, -1.0f, 1.0f);
            ms.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
            this.modelLegacy.barrel.field_3654 = Math.max(-entityRenderState.xRot / 120.0f, -0.25f);
            this.modelLegacy.method_62100(ms, builder, lm, class_4608.field_21444, color);
        } else {
            float yawRadians;
            float rot = Math.min(entityRenderState.xRot, 20.0f);
            class_4588 builder = bufs.getBuffer(class_1921.method_23576((class_2960)WeaponModResources.Entity.CANNON));
            ms.method_22905(-1.6f, -1.6f, 1.6f);
            ms.method_22903();
            ms.method_46416(0.0f, 1.0f, 0.0f);
            ms.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(rot));
            ms.method_46416(0.0f, -1.0f, 0.0f);
            this.modelBarrel.method_62100(ms, builder, lm, class_4608.field_21444, color);
            ms.method_22909();
            this.modelStandard.base1.field_3675 = yawRadians = -((float)Math.toRadians(entityRenderState.yRot));
            this.modelStandard.base2.field_3675 = yawRadians;
            this.modelStandard.baseStand.field_3675 = yawRadians;
            this.modelStandard.method_62100(ms, builder, lm, class_4608.field_21444, color);
        }
        ms.method_22909();
        super.method_3936((class_10017)entityRenderState, ms, bufs, lm);
    }

    @NotNull
    public CannonRenderState createRenderState() {
        return new CannonRenderState();
    }

    @Override
    public void extractRenderState(EntityCannon entity, CannonRenderState entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        entityRenderState.tickCount = entity.field_6012;
        entityRenderState.hurtTime = entity.method_54295();
        entityRenderState.currentDamage = entity.getCurrentDamage();
        entityRenderState.rockDirection = entity.getRockDirection();
        entityRenderState.superPowered = entity.isSuperPowered();
    }

    public static class CannonRenderState
    extends WMRenderer.WMRendererState {
        public int tickCount;
        public int hurtTime;
        public int currentDamage;
        public int rockDirection;
        public boolean superPowered;
    }
}

