/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.WMUtil;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_5819;

public class AdvancedExplosion
extends class_1927 {
    protected static final Random rand = new Random();
    public final class_1937 worldObj;
    public final class_1282 damageSource;
    public final double explosionX;
    public final double explosionY;
    public final double explosionZ;
    public final class_1297 exploder;
    public final float explosionSize;
    protected boolean blocksCalculated;

    public AdvancedExplosion(class_1937 world, class_1297 entity, double x, double y, double z, float size, boolean flame, class_1927.class_4179 mode) {
        super(world, entity, null, null, x, y, z, size, flame, mode);
        this.worldObj = world;
        this.damageSource = world.method_48963().method_48807((class_1927)this);
        this.exploder = entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = size;
    }

    public void setAffectedBlockPositions(List<class_2338> list) {
        this.method_8346().addAll(list);
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(this.damageSource);
    }

    public void doEntityExplosion(class_1282 damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = class_3532.method_15357((double)(this.explosionX - (double)size - 1.0));
        int l1 = class_3532.method_15357((double)(this.explosionX + (double)size + 1.0));
        int i2 = class_3532.method_15357((double)(this.explosionY - (double)size - 1.0));
        int i3 = class_3532.method_15357((double)(this.explosionY + (double)size + 1.0));
        int j2 = class_3532.method_15357((double)(this.explosionZ - (double)size - 1.0));
        int j3 = class_3532.method_15357((double)(this.explosionZ + (double)size + 1.0));
        List list = this.worldObj.method_8335(this.exploder, new class_238((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        class_243 vec31 = new class_243(this.explosionX, this.explosionY, this.explosionZ);
        for (class_1297 entity : list) {
            double dz;
            double dy;
            double dx;
            double d;
            double dr;
            if (entity.method_5659() || !((dr = Math.sqrt(entity.method_5649(this.explosionX, this.explosionY, this.explosionZ)) / (double)size) <= 1.0) || (d = Math.sqrt((dx = entity.method_23317() - this.explosionX) * dx + (dy = entity.method_23318() - this.explosionY) * dy + (dz = entity.method_23321() - this.explosionZ) * dz)) == 0.0) continue;
            dx /= d;
            dy /= d;
            dz /= d;
            double dens = AdvancedExplosion.method_17752((class_243)vec31, (class_1297)entity);
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.method_5643(damagesource, (float)damage);
            entity.method_18799(entity.method_18798().method_1031(dx * var36, dy * var36, dz * var36));
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        ObjectArrayList objectarraylist = new ObjectArrayList();
        ObjectArrayList positions = new ObjectArrayList((Collection)this.method_8346());
        class_156.method_43028((ObjectArrayList)positions, (class_5819)WMUtil.RANDOM);
        for (class_2338 blockpos : positions) {
            class_1937 class_19372;
            class_2680 blockstate = this.worldObj.method_8320(blockpos);
            class_2248 block = blockstate.method_26204();
            if (blockstate.method_26215()) continue;
            class_2338 blockpos1 = blockpos.method_10062();
            this.worldObj.method_16107().method_15396("explosion_blocks");
            if (block.method_9533((class_1927)this) && (class_19372 = this.worldObj) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_2586 tileentity = blockstate.method_31709() ? this.worldObj.method_8321(blockpos) : null;
                class_47.class_48 lcBuilder = new class_47.class_48(serverLevel).method_311(WMUtil.RANDOM).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockpos)).method_312(class_181.field_1229, (Object)class_1799.field_8037).method_306(class_181.field_1228, (Object)tileentity).method_306(class_181.field_1226, (Object)this.exploder).method_312(class_181.field_1225, (Object)Float.valueOf(this.explosionSize));
                blockstate.method_26189(lcBuilder).forEach(s -> AdvancedExplosion.method_24023((ObjectArrayList)objectarraylist, (class_1799)s, (class_2338)blockpos1));
            }
            this.worldObj.method_8501(blockpos, class_2246.field_10124.method_9564());
            block.method_9586(this.worldObj, blockpos, (class_1927)this);
            this.worldObj.method_16107().method_15407();
        }
        for (Pair pair : objectarraylist) {
            class_2248.method_9577((class_1937)this.worldObj, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
        }
    }

    public void doFlaming() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (class_2338 blockpos : this.method_8346()) {
            if (!this.worldObj.method_8320(blockpos).method_26215() || !this.worldObj.method_8320(blockpos.method_10074()).method_26216((class_1922)this.worldObj, blockpos.method_10074()) || rand.nextInt(3) != 0) continue;
            this.worldObj.method_8501(blockpos, class_2246.field_10036.method_9564());
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        this.worldObj.method_43128(null, this.explosionX, this.explosionY, this.explosionZ, class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (WMUtil.RANDOM.method_43057() - WMUtil.RANDOM.method_43057()) * 0.2f) * 0.7f);
        if (bigparticles && this.worldObj.method_8608()) {
            this.worldObj.method_8406((class_2394)class_2398.field_11236, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0);
        }
        if (!smallparticles) {
            return;
        }
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (class_2338 blockpos : this.method_8346()) {
            double px = (float)blockpos.method_10263() + WMUtil.RANDOM.method_43057();
            double py = (float)blockpos.method_10264() + WMUtil.RANDOM.method_43057();
            double pz = (float)blockpos.method_10260() + WMUtil.RANDOM.method_43057();
            double dx = px - this.explosionX;
            double dy = py - this.explosionY;
            double dz = pz - this.explosionZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)this.explosionSize + 0.1);
            dx *= (d7 *= (double)(WMUtil.RANDOM.method_43057() * WMUtil.RANDOM.method_43057() + 0.3f));
            dy *= d7;
            dz *= d7;
            if (!this.worldObj.method_8608()) continue;
            this.worldObj.method_8406((class_2394)class_2398.field_11203, (px + this.explosionX) / 2.0, (py + this.explosionY) / 2.0, (pz + this.explosionZ) / 2.0, dx, dy, dz);
            this.worldObj.method_8406((class_2394)class_2398.field_11251, px, py, pz, dx, dy, dz);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < maxsize; ++j) {
            for (int k = 0; k < maxsize; ++k) {
                for (int l = 0; l < maxsize; ++l) {
                    if (j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1 && l != 0 && l != maxsize - 1) continue;
                    double rx = (float)j / 15.0f * 2.0f - 1.0f;
                    double ry = (float)k / 15.0f * 2.0f - 1.0f;
                    double rz = (float)l / 15.0f * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.explosionX;
                    double dy = this.explosionY;
                    double dz = this.explosionZ;
                    float f = 0.3f;
                    for (float strength = this.explosionSize * (0.7f + WMUtil.RANDOM.method_43057() * 0.6f); strength > 0.0f; strength -= 0.22500001f) {
                        class_2338 blockpos = class_2338.method_49637((double)dx, (double)dy, (double)dz);
                        class_2680 iblockstate = this.worldObj.method_8320(blockpos);
                        if (!iblockstate.method_26215()) {
                            strength -= (iblockstate.method_26204().method_9520() + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(blockpos);
                        }
                        dx += rx * 0.3;
                        dy += ry * 0.3;
                        dz += rz * 0.3;
                    }
                }
            }
        }
        this.method_8346().addAll(set);
        this.blocksCalculated = true;
    }
}

