/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WarhammerExplosion;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1839;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class MeleeCompWarhammer
extends MeleeComponent {
    public static final int CHARGE_DELAY = 400;
    public static final String WOOD_ID = "warhammer.wood";
    public static final ItemMelee WOOD_ITEM = WMItemBuilder.createStandardWarhammer((class_1832)class_1834.field_8922);
    public static final String STONE_ID = "warhammer.stone";
    public static final ItemMelee STONE_ITEM = WMItemBuilder.createStandardWarhammer((class_1832)class_1834.field_8927);
    public static final String IRON_ID = "warhammer.iron";
    public static final ItemMelee IRON_ITEM = WMItemBuilder.createStandardWarhammer((class_1832)class_1834.field_8923);
    public static final String GOLD_ID = "warhammer.gold";
    public static final ItemMelee GOLD_ITEM = WMItemBuilder.createStandardWarhammer((class_1832)class_1834.field_8929);
    public static final String DIAMOND_ID = "warhammer.diamond";
    public static final ItemMelee DIAMOND_ITEM = WMItemBuilder.createStandardWarhammer((class_1832)class_1834.field_8930);
    public static final String NETHERITE_ID = "warhammer.netherite";
    public static final ItemMelee NETHERITE_ITEM = WMItemBuilder.createStandardWarhammer((class_1832)class_1834.field_22033);

    public MeleeCompWarhammer(class_1832 itemTier) {
        super(MeleeComponent.MeleeSpecs.WARHAMMER, itemTier);
    }

    @Override
    public float getDestroySpeed(class_1799 itemstack, class_2680 block) {
        float f = super.getDestroySpeed(itemstack, block);
        float f2 = this.weaponMaterial.method_8028() + 2.0f;
        return f * f2;
    }

    @Override
    public void releaseUsing(class_1799 itemstack, class_1937 world, class_1309 entityliving, int i) {
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 4.0f) > 1.0f) {
            this.superSmash(itemstack, world, entityliving);
        }
    }

    protected void superSmash(class_1799 itemstack, class_1937 world, class_1309 entityLiving) {
        class_1282 class_12822;
        class_1657 player;
        entityLiving.method_6104(class_1268.field_5808);
        float f = this.getEntityDamage() / 2.0f;
        WarhammerExplosion expl = new WarhammerExplosion(world, (class_1297)entityLiving, entityLiving.method_23317(), entityLiving.method_23318(), entityLiving.method_23321(), f, false, class_1927.class_4179.field_18687);
        if (entityLiving instanceof class_1657) {
            player = (class_1657)entityLiving;
            class_12822 = world.method_48963().method_48802(player);
        } else {
            class_12822 = world.method_48963().method_48812(entityLiving);
        }
        class_1282 source = class_12822;
        expl.doEntityExplosion(source);
        expl.doParticleExplosion(true, false);
        PhysHelper.sendExplosion(world, expl, true, false);
        itemstack.method_7956(16, entityLiving, s -> s.method_20236(class_1268.field_5808));
        if (entityLiving instanceof class_1657) {
            player = (class_1657)entityLiving;
            player.method_7322(6.0f);
            this.setSmashed(player);
        }
    }

    public void setSmashed(class_1657 entityplayer) {
        PlayerWeaponData.setLastWarhammerSmashTicks(entityplayer, entityplayer.field_6012);
    }

    public boolean isCharged(class_1657 player) {
        return this.getCooldown(player) <= 0;
    }

    public float getScaledCooldown(class_1657 player) {
        return (float)this.getCooldown(player) / 400.0f;
    }

    public int getCooldown(class_1657 player) {
        return PlayerWeaponData.getLastWarhammerSmashTicks(player) + 400 - player.field_6012;
    }

    @Override
    public class_1839 getUseAnimation(class_1799 itemstack) {
        return class_1839.field_8953;
    }

    @Override
    public int getUseDuration(class_1799 itemstack) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1799 itemstack, class_1937 world, class_1657 entityplayer, class_1268 hand) {
        if (itemstack.method_7960()) {
            return new class_1271(class_1269.field_5814, (Object)itemstack);
        }
        if (this.isCharged(entityplayer)) {
            entityplayer.method_6019(hand);
            return new class_1271(class_1269.field_5812, (Object)itemstack);
        }
        return new class_1271(class_1269.field_5814, (Object)itemstack);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderCooldown() {
        return class_310.method_1551().field_1724 != null && !this.isCharged((class_1657)class_310.method_1551().field_1724);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float getCooldown() {
        return class_310.method_1551().field_1724 == null ? 0.0f : this.getScaledCooldown((class_1657)class_310.method_1551().field_1724);
    }
}

