/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.render.ModelCannonBarrel;
import ckathode.weaponmod.render.ModelCannonLegacy;
import ckathode.weaponmod.render.ModelCannonStandard;
import ckathode.weaponmod.render.WMRenderer;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

public class RenderCannon
extends WMRenderer<EntityCannon> {
    private final ModelCannonBarrel modelBarrel;
    private final ModelCannonStandard modelStandard;
    private final ModelCannonLegacy modelLegacy;

    public RenderCannon(class_5617.class_5618 context) {
        super(context);
        this.modelBarrel = new ModelCannonBarrel(context.method_32167(ModelCannonBarrel.CANNON_BARREL_LAYER));
        this.modelStandard = new ModelCannonStandard(context.method_32167(ModelCannonStandard.CANNON_STANDARD_LAYER));
        this.modelLegacy = new ModelCannonLegacy(context.method_32167(ModelCannonLegacy.CANNON_LEGACY_LAYER));
        this.field_4673 = 0.7f;
    }

    public void render(@NotNull EntityCannon entitycannon, float f, float f1, @NotNull class_4587 ms, @NotNull class_4597 bufs, int lm) {
        ms.method_22903();
        f = this.interpolateRotation(entitycannon.field_5982, entitycannon.method_36454(), f1);
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.method_22904(0.0, 0.1, 0.0);
            ms.method_22907(class_7833.field_40716.rotationDegrees(-f));
        } else {
            ms.method_46416(0.0f, 2.375f, 0.0f);
            ms.method_22907(class_7833.field_40716.rotationDegrees(180.0f - f));
        }
        float f2 = (float)entitycannon.method_7533() - f1;
        float f3 = (float)entitycannon.getCurrentDamage() - f1;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            ms.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)f2) * f2 * f3 / 10.0f * (float)entitycannon.getRockDirection() / 5.0f));
        }
        class_4588 builder = bufs.getBuffer(class_1921.method_23576((class_2960)this.getTextureLocation(entitycannon)));
        float f4 = 1.0f;
        if (entitycannon.isSuperPowered() && entitycannon.field_6012 % 5 < 2) {
            f4 = 1.5f;
        }
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.method_22905(-1.0f, -1.0f, 1.0f);
            ms.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            this.modelLegacy.barrel.field_3654 = Math.max(-entitycannon.method_36455() / 120.0f, -0.25f);
            this.modelLegacy.method_2828(ms, builder, lm, class_4608.field_21444, f4, f4, f4, 1.0f);
        } else {
            float yawRadians;
            float rot = entitycannon.field_6004 + (entitycannon.method_36455() - entitycannon.field_6004) * f1;
            rot = Math.min(rot, 20.0f);
            ms.method_22905(-1.6f, -1.6f, 1.6f);
            ms.method_22903();
            ms.method_46416(0.0f, 1.0f, 0.0f);
            ms.method_22907(class_7833.field_40714.rotationDegrees(rot));
            ms.method_46416(0.0f, -1.0f, 0.0f);
            this.modelBarrel.method_2828(ms, builder, lm, class_4608.field_21444, f4, f4, f4, 1.0f);
            ms.method_22909();
            this.modelStandard.base1.field_3675 = yawRadians = -((float)Math.toRadians(f));
            this.modelStandard.base2.field_3675 = yawRadians;
            this.modelStandard.baseStand.field_3675 = yawRadians;
            this.modelStandard.method_2828(ms, builder, lm, class_4608.field_21444, f4, f4, f4, 1.0f);
        }
        ms.method_22909();
        super.method_3936((class_1297)entitycannon, f, f1, ms, bufs, lm);
    }

    private float interpolateRotation(float from, float to, float by) {
        return (from + class_3532.method_15393((float)(to - from)) * by) % 360.0f;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull EntityCannon entity) {
        return WeaponModConfig.get().legacyCannonModel ? WeaponModResources.Entity.CANNON_LEGACY : WeaponModResources.Entity.CANNON;
    }
}

