/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.entity.projectile.MaterialRegistry;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.ItemHitEffect;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMaterialProjectile<T extends EntityMaterialProjectile<T>>
extends EntityProjectile<T> {
    private static final EntityDataAccessor<Integer> WEAPON_MATERIAL = SynchedEntityData.defineId(EntityMaterialProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> WEAPON_ITEM = SynchedEntityData.defineId(EntityMaterialProjectile.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final float[][] MATERIAL_COLORS = new float[][]{{0.6f, 0.4f, 0.1f}, {0.5f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f}, {0.0f, 0.8f, 0.7f}, {1.0f, 0.9f, 0.0f}, {0.3f, 0.3f, 0.3f}};

    public EntityMaterialProjectile(EntityType<T> type, Level world) {
        super(type, world);
    }

    public EntityMaterialProjectile(EntityType<T> type, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, world, firedFromWeapon);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WEAPON_MATERIAL, (Object)0);
        builder.define(WEAPON_ITEM, (Object)ItemStack.EMPTY);
    }

    @Override
    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        super.saveAdditionalSpawnData(buf);
        buf.writeInt(this.getWeaponMaterialId());
        ItemStack.STREAM_CODEC.encode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, this.registryAccess()), (Object)this.getWeapon());
    }

    @Override
    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        super.loadAdditionalSpawnData(buf);
        this.entityData.set(WEAPON_MATERIAL, (Object)buf.readInt());
        this.entityData.set(WEAPON_ITEM, (Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, this.registryAccess()))));
    }

    public float applyEnchantmentBonus(Entity entity, float baseDamage) {
        Level level;
        Entity shooter = this.getOwner();
        ItemStack weaponItem = this.getWeaponItem();
        if (weaponItem != null && shooter instanceof LivingEntity && entity instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            baseDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)weaponItem, (Entity)entity, (DamageSource)this.getDamageSource(), (float)baseDamage);
        }
        return baseDamage;
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Item item;
        super.onHitEntity(result);
        ItemStack thrownItem = this.getWeapon();
        if (!thrownItem.isEmpty() && (item = thrownItem.getItem()) instanceof ItemHitEffect) {
            ItemHitEffect ihe = (ItemHitEffect)item;
            ihe.onHitEntity(this, result);
        }
    }

    @Override
    public void onHitBlock(BlockHitResult result) {
        Item item;
        super.onHitBlock(result);
        ItemStack thrownItem = this.getWeapon();
        if (!thrownItem.isEmpty() && (item = thrownItem.getItem()) instanceof ItemHitEffect) {
            ItemHitEffect ihe = (ItemHitEffect)item;
            ihe.onHitBlock(this, result);
        }
    }

    @Override
    public void applyEntityHitEffects(Entity entity) {
        Holder fireAspect;
        int i;
        super.applyEntityHitEffects(entity);
        ItemStack stack = this.getWeapon();
        Registry enchRegistry = this.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        if (entity instanceof LivingEntity) {
            int i2;
            LivingEntity livingEntity = (LivingEntity)entity;
            Holder knockBack = enchRegistry.get(Enchantments.KNOCKBACK).orElse(null);
            int n = i2 = knockBack == null ? 0 : EnchantmentHelper.getItemEnchantmentLevel((Holder)knockBack, (ItemStack)stack);
            if (i2 != 0) {
                livingEntity.knockback((double)((float)i2 * 0.4f), (double)(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
            }
        }
        int n = i = (fireAspect = (Holder)enchRegistry.get(Enchantments.FIRE_ASPECT).orElse(null)) == null ? 0 : EnchantmentHelper.getItemEnchantmentLevel((Holder)fireAspect, (ItemStack)stack);
        if (i > 0 || this.isOnFire()) {
            entity.igniteForSeconds(i > 0 ? (float)i : 1.0f);
        }
    }

    public void setThrownItemStack(@NotNull ItemStack itemstack) {
        this.entityData.set(WEAPON_ITEM, (Object)itemstack);
        this.updateWeaponMaterial();
    }

    @Override
    @NotNull
    public ItemStack getPickupItem() {
        return this.getWeapon();
    }

    public int getWeaponMaterialId() {
        return (Integer)this.entityData.get(WEAPON_MATERIAL);
    }

    @NotNull
    public ItemStack getWeapon() {
        return (ItemStack)this.entityData.get(WEAPON_ITEM);
    }

    protected void updateWeaponMaterial() {
        IItemWeapon weapon;
        Item item;
        ItemStack thrownItem = this.getWeapon();
        if (!thrownItem.isEmpty() && (item = thrownItem.getItem()) instanceof IItemWeapon && (weapon = (IItemWeapon)item).getMeleeComponent() != null) {
            int material = MaterialRegistry.getMaterialID(thrownItem);
            if (material < 0) {
                material = MaterialRegistry.getOrdinal(weapon.getMeleeComponent().weaponMaterial);
            }
            this.entityData.set(WEAPON_MATERIAL, (Object)material);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getMaterialColor() {
        int id = this.getWeaponMaterialId();
        if (id >= 0 && id < MATERIAL_COLORS.length) {
            return MATERIAL_COLORS[id];
        }
        return MaterialRegistry.getColorFromMaterialID(id);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        ItemStack thrownItem = this.getWeapon();
        valueOutput.store("thrI", ItemStack.CODEC, (Object)thrownItem);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setThrownItemStack(valueInput.read("thrI", ItemStack.CODEC).orElse(ItemStack.EMPTY));
    }
}

