/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeleeCompFirerod
extends MeleeComponent {
    public static final String ID = "firerod";
    public static final ItemMelee ITEM = WMItemBuilder.createStandardFirerod(BalkonsWeaponMod.id("firerod"));

    public MeleeCompFirerod() {
        super(MeleeComponent.MeleeSpecs.FIREROD, ToolMaterial.WOOD);
    }

    @Override
    public void hurtEnemy(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity entityliving1) {
        super.hurtEnemy(itemstack, entityliving, entityliving1);
        Holder fireAspect = entityliving.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FIRE_ASPECT).orElse(null);
        int enchBonus = fireAspect != null ? 2 * EnchantmentHelper.getItemEnchantmentLevel((Holder)fireAspect, (ItemStack)itemstack) : 0;
        entityliving.igniteForSeconds((float)(12 + enchBonus + entityliving.getRandom().nextInt(3)));
    }

    @Override
    @NotNull
    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.NONE;
    }

    @Override
    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull ServerLevel serverLevel, @NotNull Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        boolean offHand;
        super.inventoryTick(itemStack, serverLevel, entity, equipmentSlot);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.isInWater()) {
            return;
        }
        boolean mainHand = player.getMainHandItem() == itemStack;
        boolean bl = offHand = player.getOffhandItem() == itemStack;
        if (!mainHand && !offHand) {
            return;
        }
        float f = 1.0f;
        float f1 = offHand ^ player.getMainArm() == HumanoidArm.LEFT ? -28.0f : 28.0f;
        float particleX = -Mth.sin((float)((player.getYRot() + f1) / 180.0f * 3.141593f)) * Mth.cos((float)(player.getXRot() / 180.0f * 3.141593f)) * f;
        float particleY = -Mth.sin((float)(player.getXRot() / 180.0f * 3.141593f)) + player.getEyeHeight();
        float particleZ = Mth.cos((float)((player.getYRot() + f1) / 180.0f * 3.141593f)) * Mth.cos((float)(player.getXRot() / 180.0f * 3.141593f)) * f;
        if (serverLevel.isClientSide()) {
            if (player.getRandom().nextInt(5) == 0) {
                serverLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, player.getX() + (double)particleX, player.getY() + (double)particleY, player.getZ() + (double)particleZ, 0.0, 0.0, 0.0);
            }
            if (player.getRandom().nextInt(5) == 0) {
                serverLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, player.getX() + (double)particleX, player.getY() + (double)particleY, player.getZ() + (double)particleZ, 0.0, 0.0, 0.0);
            }
        }
    }
}

