/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.entity.projectile.EntityBlunderShot;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RangedCompBlunderbuss
extends RangedComponent {
    public static final String ID = "blunderbuss";
    public static final ItemShooter ITEM = WMItemBuilder.createStandardBlunderbuss(BalkonsWeaponMod.id("blunderbuss"));

    public RangedCompBlunderbuss() {
        super(RangedComponent.RangedSpecs.BLUNDERBUSS);
    }

    @Override
    public void effectReloadDone(ItemStack itemstack, Level world, LivingEntity entityliving) {
        entityliving.swing(InteractionHand.MAIN_HAND);
        world.playSound(null, entityliving.getX(), entityliving.getY(), entityliving.getZ(), SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.PLAYERS, 0.8f, 1.0f / (entityliving.getRandom().nextFloat() * 0.2f + 0.0f));
    }

    @Override
    public void fire(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        if (!world.isClientSide()) {
            EntityBlunderShot.fireSpreadShot(world, entityliving, this, itemstack);
        }
        int damage = 1;
        if (itemstack.getDamageValue() + damage < itemstack.getMaxDamage()) {
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        }
        itemstack.hurtAndBreak(damage, entityliving, entityliving.getUsedItemHand().asEquipmentSlot());
        this.postShootingEffects(itemstack, entityliving, world);
    }

    @Override
    public void effectPlayer(ItemStack itemstack, Player entityplayer, Level world) {
        float f = entityplayer.isShiftKeyDown() ? -0.1f : -0.2f;
        double d = -Mth.sin((float)(entityplayer.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)0.0f) * f;
        double d2 = Mth.cos((float)(entityplayer.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)0.0f) * f;
        entityplayer.setXRot(entityplayer.getXRot() - (entityplayer.isShiftKeyDown() ? 17.5f : 25.0f));
        entityplayer.push(d, 0.0, d2);
    }

    @Override
    public void effectShoot(Level world, double x, double y, double z, float yaw, float pitch) {
        world.playSound(null, x, y, z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.PLAYERS, 3.0f, 1.0f / (WMUtil.RANDOM.nextFloat() * 0.4f + 0.6f));
        float particleX = -Mth.sin((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float particleY = -Mth.sin((float)(pitch * ((float)Math.PI / 180))) + 1.6f;
        float particleZ = Mth.cos((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        if (world.isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0);
            }
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float getMaxZoom() {
        return 0.07f;
    }
}

