/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.projectile.EntityBoomerang;
import ckathode.weaponmod.render.WMItemEntityRenderer;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class RenderBoomerang
extends WMItemEntityRenderer<EntityBoomerang, BoomerangRenderState> {
    public RenderBoomerang(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void submitNormalRender(BoomerangRenderState entityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        int lm = entityRenderState.lightCoords;
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(entityRenderState.xRot));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(entityRenderState.yRot - 90.0f));
        int material = entityRenderState.weaponMaterialId;
        float[] color = entityRenderState.materialColor;
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)WeaponModResources.Entity.BOOMERANG), (pose, consumer) -> {
            this.drawVertex(pose, consumer, 0.0f, 0.0f, 1.0f, 0.5f, 0.0f, 0.0f, 1.0f, 0.0f, lm);
            this.drawVertex(pose, consumer, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, lm);
            this.drawVertex(pose, consumer, 1.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, lm);
            this.drawVertex(pose, consumer, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f, lm);
            if (material != 0) {
                this.drawVertex(pose, consumer, 0.0f, 0.0f, 1.0f, color[0], color[1], color[2], 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(pose, consumer, 1.0f, 0.0f, 1.0f, color[0], color[1], color[2], 1.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(pose, consumer, 1.0f, 0.0f, 0.0f, color[0], color[1], color[2], 1.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(pose, consumer, 0.0f, 0.0f, 0.0f, color[0], color[1], color[2], 1.0f, 1.0f, 0.5f, 0.0f, 0.0f, 0.05625f, lm);
            }
            this.drawVertex(pose, consumer, 1.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, -1.0f, 0.0f, lm);
            this.drawVertex(pose, consumer, 1.0f, 0.0f, 1.0f, 0.5f, 0.5f, 0.0f, -1.0f, 0.0f, lm);
            this.drawVertex(pose, consumer, 0.0f, 0.0f, 1.0f, 0.5f, 0.0f, 0.0f, -1.0f, 0.0f, lm);
            this.drawVertex(pose, consumer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, lm);
            if (material != 0) {
                this.drawVertex(pose, consumer, 1.0f, 0.0f, 0.0f, color[0], color[1], color[2], 1.0f, 0.5f, 0.5f, 0.0f, -1.0f, 0.0f, lm);
                this.drawVertex(pose, consumer, 1.0f, 0.0f, 1.0f, color[0], color[1], color[2], 1.0f, 1.0f, 0.5f, 0.0f, -1.0f, 0.0f, lm);
                this.drawVertex(pose, consumer, 0.0f, 0.0f, 1.0f, color[0], color[1], color[2], 1.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, lm);
                this.drawVertex(pose, consumer, 0.0f, 0.0f, 0.0f, color[0], color[1], color[2], 1.0f, 0.5f, 0.0f, 0.0f, -1.0f, 0.0f, lm);
            }
            GlStateManager._disableCull();
            this.drawVertex(pose, consumer, 0.2f, -0.08f, 0.8f, 0.5f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
            this.drawVertex(pose, consumer, 0.2f, 0.08f, 0.8f, 0.5f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
            this.drawVertex(pose, consumer, 0.9f, 0.08f, 0.8f, 0.0f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
            this.drawVertex(pose, consumer, 0.9f, -0.08f, 0.8f, 0.0f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
            if (material != 0) {
                this.drawVertex(pose, consumer, 0.2f, -0.08f, 0.8f, color[0], color[1], color[2], 1.0f, 1.0f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
                this.drawVertex(pose, consumer, 0.2f, 0.08f, 0.8f, color[0], color[1], color[2], 1.0f, 1.0f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
                this.drawVertex(pose, consumer, 0.9f, 0.08f, 0.8f, color[0], color[1], color[2], 1.0f, 0.5f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
                this.drawVertex(pose, consumer, 0.9f, -0.08f, 0.8f, color[0], color[1], color[2], 1.0f, 0.5f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
            }
            this.drawVertex(pose, consumer, 0.2f, -0.08f, 0.8f, 0.5f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
            this.drawVertex(pose, consumer, 0.2f, 0.08f, 0.8f, 0.5f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
            this.drawVertex(pose, consumer, 0.2f, 0.08f, 0.2f, 0.0f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
            this.drawVertex(pose, consumer, 0.2f, -0.08f, 0.2f, 0.0f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
            if (material != 0) {
                this.drawVertex(pose, consumer, 0.2f, -0.08f, 0.8f, color[0], color[1], color[2], 1.0f, 1.0f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
                this.drawVertex(pose, consumer, 0.2f, 0.08f, 0.8f, color[0], color[1], color[2], 1.0f, 1.0f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
                this.drawVertex(pose, consumer, 0.2f, 0.08f, 0.2f, color[0], color[1], color[2], 1.0f, 0.5f, 0.65625f, -SQRT2, 0.0f, SQRT2, lm);
                this.drawVertex(pose, consumer, 0.2f, -0.08f, 0.2f, color[0], color[1], color[2], 1.0f, 0.5f, 0.5f, -SQRT2, 0.0f, SQRT2, lm);
            }
            GlStateManager._enableCull();
        });
        poseStack.popPose();
    }

    @Override
    public void submitItemRender(BoomerangRenderState entityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.scale(0.85f, 0.85f, 0.85f);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(entityRenderState.xRot));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(entityRenderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        entityRenderState.itemRender.submit(poseStack, submitNodeCollector, entityRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }

    @NotNull
    public BoomerangRenderState createRenderState() {
        return new BoomerangRenderState();
    }

    @Override
    public void extractRenderState(EntityBoomerang entity, BoomerangRenderState entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        entityRenderState.weaponMaterialId = entity.getWeaponMaterialId();
        entityRenderState.materialColor = entity.getMaterialColor();
    }

    @Override
    public ItemStack getRenderStack(EntityBoomerang entity, BoomerangRenderState entityRenderState, float f) {
        return entity.getWeapon();
    }

    public static class BoomerangRenderState
    extends WMItemEntityRenderer.WMItemEntityRendererState {
        public int weaponMaterialId;
        public float[] materialColor;
    }
}

