/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.EntityDummy;
import ckathode.weaponmod.render.ModelDummy;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class RenderDummy
extends WMRenderer<EntityDummy, DummyRenderState> {
    private final ModelDummy modelDummy;

    public RenderDummy(EntityRendererProvider.Context context) {
        super(context);
        this.modelDummy = new ModelDummy(context.bakeLayer(ModelDummy.MAIN_LAYER));
        this.shadowRadius = 0.7f;
    }

    public void submit(DummyRenderState entityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        int lm = entityRenderState.lightCoords;
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.025f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - entityRenderState.yRot));
        float f2 = entityRenderState.timeSinceHit;
        float f3 = entityRenderState.currentDamage;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(Mth.sin((float)f2) * f2 * f3 / 10.0f * (float)entityRenderState.rockDirection / 5.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        submitNodeCollector.submitModel((Model)this.modelDummy, (Object)entityRenderState, poseStack, RenderType.entityCutout((ResourceLocation)WeaponModResources.Entity.DUMMY), lm, OverlayTexture.NO_OVERLAY, -1, null, entityRenderState.outlineColor, null);
        poseStack.popPose();
        super.submit((EntityRenderState)entityRenderState, poseStack, submitNodeCollector, cameraRenderState);
    }

    @NotNull
    public DummyRenderState createRenderState() {
        return new DummyRenderState();
    }

    @Override
    public void extractRenderState(EntityDummy entity, DummyRenderState entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        entityRenderState.timeSinceHit = (float)entity.getTimeSinceHit() - f;
        entityRenderState.currentDamage = (float)entity.getCurrentDamage() - f;
        entityRenderState.rockDirection = entity.getRockDirection();
    }

    public static class DummyRenderState
    extends WMRenderer.WMRendererState {
        public float timeSinceHit;
        public float currentDamage;
        public int rockDirection;
    }
}

