/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityCannonBall
extends EntityProjectile<EntityCannonBall> {
    public static final String ID = "cannonball";
    public static final EntityType<EntityCannonBall> TYPE = WMRegistries.createEntityType("cannonball", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityCannonBall::new);

    public EntityCannonBall(EntityType<EntityCannonBall> entityType, Level world) {
        super(entityType, world);
    }

    public EntityCannonBall(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.setPos(d, d1, d2);
    }

    public EntityCannonBall(Level world, EntityCannon entitycannon, float f, float f1, boolean superPowered) {
        this(world, entitycannon.getX(), entitycannon.getY() + 1.0, entitycannon.getZ());
        Entity entityPassenger = entitycannon.getPassengers().isEmpty() ? null : (Entity)entitycannon.getPassengers().getFirst();
        this.setOwner((Entity)entitycannon);
        if (entityPassenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityPassenger;
            this.setPickupStatusFromEntity(livingEntity);
        } else {
            this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        }
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, superPowered ? 4.0f : 2.0f, superPowered ? 0.1f : 2.0f);
        Vec3 cannonMotion = entitycannon.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(cannonMotion.x, 0.0, cannonMotion.z));
        this.setCritArrow(superPowered);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    @Override
    public void tick() {
        super.tick();
        double speed = this.getDeltaMovement().length();
        double amount = 8.0;
        if (speed > 1.0) {
            Vec3 motion = this.getDeltaMovement();
            int i1 = 1;
            while ((double)i1 < amount) {
                Vec3 pos = this.position().add(motion.scale((double)i1 / amount));
                if (this.level().isClientSide()) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                }
                ++i1;
            }
        }
    }

    public void createCrater() {
        if (this.level().isClientSide || !this.inGround || this.isInWater()) {
            return;
        }
        this.remove(Entity.RemovalReason.DISCARDED);
        float f = this.isCritArrow() ? 5.0f : 2.5f;
        PhysHelper.createAdvancedExplosion(this.level(), (Entity)this, this.getX(), this.getY(), this.getZ(), f, WeaponModConfig.get().cannonDoesBlockDamage, true, false, Explosion.BlockInteraction.DESTROY);
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        DamageSource damagesource = this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
        if (result.getEntity().hurt(damagesource, 30.0f)) {
            this.playSound(SoundEvents.PLAYER_HURT, 1.0f, 1.2f / (this.random.nextFloat() * 0.4f + 0.7f));
        }
    }

    @Override
    public void onHitBlock(BlockHitResult result) {
        BlockPos blockpos = result.getBlockPos();
        this.xTile = blockpos.getX();
        this.yTile = blockpos.getY();
        this.zTile = blockpos.getZ();
        this.inBlockState = this.level().getBlockState(blockpos);
        this.setDeltaMovement(result.getLocation().subtract(this.position()));
        double f1 = this.getDeltaMovement().length();
        Vec3 pos = this.position().subtract(this.getDeltaMovement().scale(0.05 / f1));
        this.setPos(pos.x, pos.y, pos.z);
        this.inGround = true;
        if (this.inBlockState != null) {
            this.inBlockState.entityInside(this.level(), blockpos, (Entity)this);
        }
        this.createCrater();
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public double getDefaultGravity() {
        return 0.04f;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_CANNON_BALL.get());
    }
}

