/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityJavelin
extends EntityProjectile<EntityJavelin> {
    public static final String ID = "javelin";
    public static final EntityType<EntityJavelin> TYPE = WMRegistries.createEntityType("javelin", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityJavelin::new);

    public EntityJavelin(EntityType<EntityJavelin> entityType, Level world) {
        super(entityType, world);
    }

    public EntityJavelin(Level world, double x, double y, double z) {
        this(TYPE, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.setPos(x, y, z);
    }

    public EntityJavelin(Level world, LivingEntity shooter) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ());
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3 * 1.1f, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity;
        double vel = this.getTotalVelocity();
        int damage = Mth.ceil((double)(vel * (3.0 + (double)this.extraDamage)));
        if (this.isCritArrow()) {
            damage += this.random.nextInt(damage / 2 + 2);
        }
        if ((entity = result.getEntity()).hurt(damagesource = this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity()), (float)damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void playHitSound() {
        this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 10;
    }

    @Override
    public double getDefaultGravity() {
        return 0.03f;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_JAVELIN.get());
    }
}

