/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntitySpear
extends EntityMaterialProjectile<EntitySpear> {
    public static final String ID = "spear";
    public static final EntityType<EntitySpear> TYPE = WMRegistries.createEntityType("spear", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntitySpear::new);

    public EntitySpear(EntityType<EntitySpear> entityType, Level world) {
        super(entityType, world);
    }

    public EntitySpear(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.setPos(d, d1, d2);
    }

    public EntitySpear(Level world, LivingEntity shooter, ItemStack itemstack) {
        this(world, shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight() - 0.1, shooter.getZ());
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        IItemWeapon iiw;
        if (this.level().isClientSide) {
            return;
        }
        DamageSource damagesource = this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem.isEmpty()) {
            return;
        }
        Item item = thrownItem.getItem();
        Entity entity = result.getEntity();
        if (item instanceof IItemWeapon && entity.hurt(damagesource, (iiw = (IItemWeapon)item).getMeleeComponent().getEntityDamage() + this.getMeleeHitDamage(entity))) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            if (thrownItem.getDamageValue() + 1 >= thrownItem.getMaxDamage()) {
                thrownItem.shrink(1);
                this.remove(Entity.RemovalReason.DISCARDED);
            } else {
                ServerPlayer player;
                Entity shooter = this.getOwner();
                thrownItem.hurtAndBreak(1, this.random, shooter instanceof ServerPlayer ? (player = (ServerPlayer)shooter) : null, () -> {});
                this.lerpMotion(0.0, 0.0, 0.0);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void playHitSound() {
        this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupStatus == EntityProjectile.PickupStatus.ALLOWED || this.pickupStatus == EntityProjectile.PickupStatus.OWNER_ONLY ? 0 : 1200;
    }

    @Override
    public int getMaxArrowShake() {
        return 10;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_SPEAR_WOOD.get());
    }
}

