/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class MeleeCompFirerod
extends MeleeComponent {
    public static final String ID = "firerod";
    public static final ItemMelee ITEM = WMItemBuilder.createStandardFirerod();

    public MeleeCompFirerod() {
        super(MeleeComponent.MeleeSpecs.FIREROD, (Tier)Tiers.WOOD);
    }

    @Override
    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entityliving, LivingEntity entityliving1) {
        boolean flag = super.hurtEnemy(itemstack, entityliving, entityliving1);
        if (flag) {
            entityliving.igniteForSeconds(12 + entityliving.getRandom().nextInt(3));
        }
        return flag;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.NONE;
    }

    @Override
    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int i, boolean flag) {
        boolean offHand;
        super.inventoryTick(itemstack, world, entity, i, flag);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.isInWater()) {
            return;
        }
        boolean mainHand = player.getMainHandItem() == itemstack;
        boolean bl = offHand = player.getOffhandItem() == itemstack;
        if (!mainHand && !offHand) {
            return;
        }
        float f = 1.0f;
        float f1 = offHand ^ player.getMainArm() == HumanoidArm.LEFT ? -28.0f : 28.0f;
        float particleX = -Mth.sin((float)((player.getYRot() + f1) / 180.0f * 3.141593f)) * Mth.cos((float)(player.getXRot() / 180.0f * 3.141593f)) * f;
        float particleY = -Mth.sin((float)(player.getXRot() / 180.0f * 3.141593f)) + player.getEyeHeight();
        float particleZ = Mth.cos((float)((player.getYRot() + f1) / 180.0f * 3.141593f)) * Mth.cos((float)(player.getXRot() / 180.0f * 3.141593f)) * f;
        if (world.isClientSide()) {
            if (player.getRandom().nextInt(5) == 0) {
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, player.getX() + (double)particleX, player.getY() + (double)particleY, player.getZ() + (double)particleZ, 0.0, 0.0, 0.0);
            }
            if (player.getRandom().nextInt(5) == 0) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, player.getX() + (double)particleX, player.getY() + (double)particleY, player.getZ() + (double)particleZ, 0.0, 0.0, 0.0);
            }
        }
    }
}

