/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityKnife;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class MeleeCompKnife
extends MeleeComponent {
    public static final String WOOD_ID = "knife.wood";
    public static final ItemMelee WOOD_ITEM = WMItemBuilder.createStandardKnife((Tier)Tiers.WOOD);
    public static final String STONE_ID = "knife.stone";
    public static final ItemMelee STONE_ITEM = WMItemBuilder.createStandardKnife((Tier)Tiers.STONE);
    public static final String IRON_ID = "knife.iron";
    public static final ItemMelee IRON_ITEM = WMItemBuilder.createStandardKnife((Tier)Tiers.IRON);
    public static final String GOLD_ID = "knife.gold";
    public static final ItemMelee GOLD_ITEM = WMItemBuilder.createStandardKnife((Tier)Tiers.GOLD);
    public static final String DIAMOND_ID = "knife.diamond";
    public static final ItemMelee DIAMOND_ITEM = WMItemBuilder.createStandardKnife((Tier)Tiers.DIAMOND);
    public static final String NETHERITE_ID = "knife.netherite";
    public static final ItemMelee NETHERITE_ITEM = WMItemBuilder.createStandardKnife((Tier)Tiers.NETHERITE);

    public MeleeCompKnife(Tier itemTier) {
        super(MeleeComponent.MeleeSpecs.KNIFE, itemTier);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        if (!WeaponModConfig.get().canThrowKnife) {
            return super.use(itemstack, world, entityplayer, hand);
        }
        if (!world.isClientSide) {
            EntityKnife entityknife = new EntityKnife(world, (LivingEntity)entityplayer, itemstack.copy());
            entityknife.shootFromRotation((Entity)entityplayer, entityplayer.getXRot(), entityplayer.getYRot(), 0.0f, 0.8f, 3.0f);
            entityknife.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.KNOCKBACK, (ItemStack)itemstack));
            if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FIRE_ASPECT, (ItemStack)itemstack) > 0) {
                entityknife.igniteForSeconds(100);
            }
            world.addFreshEntity((Entity)entityknife);
        }
        world.playSound(null, entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (entityplayer.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!entityplayer.isCreative()) {
            itemstack = itemstack.copy();
            itemstack.shrink(1);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public UseAnim getUseAnimation(ItemStack itemstack) {
        return WeaponModConfig.get().canThrowKnife ? UseAnim.NONE : super.getUseAnimation(itemstack);
    }
}

