/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WarhammerExplosion;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MeleeCompWarhammer
extends MeleeComponent {
    public static final int CHARGE_DELAY = 400;
    public static final String WOOD_ID = "warhammer.wood";
    public static final ItemMelee WOOD_ITEM = WMItemBuilder.createStandardWarhammer((Tier)Tiers.WOOD);
    public static final String STONE_ID = "warhammer.stone";
    public static final ItemMelee STONE_ITEM = WMItemBuilder.createStandardWarhammer((Tier)Tiers.STONE);
    public static final String IRON_ID = "warhammer.iron";
    public static final ItemMelee IRON_ITEM = WMItemBuilder.createStandardWarhammer((Tier)Tiers.IRON);
    public static final String GOLD_ID = "warhammer.gold";
    public static final ItemMelee GOLD_ITEM = WMItemBuilder.createStandardWarhammer((Tier)Tiers.GOLD);
    public static final String DIAMOND_ID = "warhammer.diamond";
    public static final ItemMelee DIAMOND_ITEM = WMItemBuilder.createStandardWarhammer((Tier)Tiers.DIAMOND);
    public static final String NETHERITE_ID = "warhammer.netherite";
    public static final ItemMelee NETHERITE_ITEM = WMItemBuilder.createStandardWarhammer((Tier)Tiers.NETHERITE);

    public MeleeCompWarhammer(Tier itemTier) {
        super(MeleeComponent.MeleeSpecs.WARHAMMER, itemTier);
    }

    @Override
    @NotNull
    public Tool getToolComponent() {
        Tool orig = super.getToolComponent();
        return new Tool(orig.rules(), orig.defaultMiningSpeed() * (this.weaponMaterial.getAttackDamageBonus() + 2.0f), 1);
    }

    @Override
    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 4.0f) > 1.0f) {
            this.superSmash(itemstack, world, entityliving);
        }
    }

    protected void superSmash(ItemStack itemstack, Level world, LivingEntity entityLiving) {
        DamageSource damageSource;
        Player player;
        entityLiving.swing(InteractionHand.MAIN_HAND);
        float f = this.getEntityDamage() / 2.0f;
        WarhammerExplosion expl = new WarhammerExplosion(world, (Entity)entityLiving, entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), f, false, Explosion.BlockInteraction.DESTROY);
        if (entityLiving instanceof Player) {
            player = (Player)entityLiving;
            damageSource = world.damageSources().playerAttack(player);
        } else {
            damageSource = world.damageSources().mobAttack(entityLiving);
        }
        DamageSource source = damageSource;
        expl.doEntityExplosion(source);
        expl.doParticleExplosion(true, false);
        PhysHelper.sendExplosion(world, expl, true, false);
        itemstack.hurtAndBreak(16, entityLiving, EquipmentSlot.MAINHAND);
        if (entityLiving instanceof Player) {
            player = (Player)entityLiving;
            player.causeFoodExhaustion(6.0f);
            this.setSmashed(player);
        }
    }

    public void setSmashed(Player entityplayer) {
        PlayerWeaponData.setLastWarhammerSmashTicks(entityplayer, entityplayer.tickCount);
    }

    public boolean isCharged(Player player) {
        return this.getCooldown(player) <= 0;
    }

    public float getScaledCooldown(Player player) {
        return (float)this.getCooldown(player) / 400.0f;
    }

    public int getCooldown(Player player) {
        return PlayerWeaponData.getLastWarhammerSmashTicks(player) + 400 - player.tickCount;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    @Override
    public int getUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        if (itemstack.isEmpty()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        if (this.isCharged(entityplayer)) {
            entityplayer.startUsingItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderCooldown() {
        return Minecraft.getInstance().player != null && !this.isCharged((Player)Minecraft.getInstance().player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getCooldown() {
        return Minecraft.getInstance().player == null ? 0.0f : this.getScaledCooldown((Player)Minecraft.getInstance().player);
    }
}

