/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.entity.projectile.EntityBlowgunDart;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.ItemBlowgunDart;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RangedCompBlowgun
extends RangedComponent {
    public static final String ID = "blowgun";
    public static final ItemShooter ITEM = WMItemBuilder.createStandardBlowgun();

    public RangedCompBlowgun() {
        super(RangedComponent.RangedSpecs.BLOWGUN);
    }

    @Override
    public void effectReloadDone(ItemStack itemstack, Level world, LivingEntity entityliving) {
        entityliving.swing(InteractionHand.MAIN_HAND);
        world.playSound(null, entityliving.getX(), entityliving.getY(), entityliving.getZ(), SoundEvents.COMPARATOR_CLICK, SoundSource.PLAYERS, 0.8f, 1.0f / (entityliving.getRandom().nextFloat() * 0.4f + 0.4f));
    }

    @Override
    public void fire(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        ItemStack dartstack;
        if (!(entityliving instanceof Player)) {
            return;
        }
        Player entityplayer = (Player)entityliving;
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if (f < 0.1f) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((dartstack = this.findAmmo(entityplayer)).isEmpty() && entityplayer.isCreative()) {
            dartstack = new ItemStack((ItemLike)ItemBlowgunDart.ITEMS.get(DartType.damage), 1);
        }
        ItemStack dartStackCopy = dartstack.copy();
        if (!entityplayer.isCreative() && EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY, (ItemStack)itemstack) == 0) {
            this.consumeAmmo(entityplayer);
        }
        if (!world.isClientSide) {
            EntityBlowgunDart entityblowgundart = new EntityBlowgunDart(world, (LivingEntity)entityplayer);
            entityblowgundart.shootFromRotation((Entity)entityplayer, entityplayer.getXRot(), entityplayer.getYRot(), 0.0f, f * 1.5f, 1.0f);
            Item item = dartStackCopy.getItem();
            if (item instanceof ItemBlowgunDart) {
                ItemBlowgunDart dart = (ItemBlowgunDart)item;
                entityblowgundart.setDartEffectType(dart.getDartType());
            }
            this.applyProjectileEnchantments(entityblowgundart, itemstack);
            world.addFreshEntity((Entity)entityblowgundart);
        }
        int damage = 1;
        if (itemstack.getDamageValue() + damage < itemstack.getMaxDamage()) {
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        }
        itemstack.hurtAndBreak(damage, (LivingEntity)entityplayer, LivingEntity.getSlotForHand((InteractionHand)entityplayer.getUsedItemHand()));
        this.postShootingEffects(itemstack, (LivingEntity)entityplayer, world);
        RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
    }

    @Override
    public boolean hasAmmoAndConsume(ItemStack itemstack, Level world, LivingEntity entityliving) {
        if (!(entityliving instanceof Player)) {
            return false;
        }
        Player player = (Player)entityliving;
        return this.hasAmmo(itemstack, world, player);
    }

    @Override
    public void soundEmpty(ItemStack itemstack, Level world, Player entityplayer) {
        world.playSound(null, entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (entityplayer.getRandom().nextFloat() * 0.2f + 0.5f));
    }

    @Override
    public void soundCharge(ItemStack itemstack, Level world, Player entityplayer) {
        world.playSound(null, entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), SoundEvents.PLAYER_BREATH, SoundSource.PLAYERS, 1.0f, 1.0f / (entityplayer.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public void effectShoot(Level world, double x, double y, double z, float yaw, float pitch) {
        world.playSound(null, x, y, z, SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (WMUtil.RANDOM.nextFloat() * 0.2f + 0.5f));
        float particleX = -Mth.sin((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float particleY = -Mth.sin((float)(pitch * ((float)Math.PI / 180))) + 1.6f;
        float particleZ = Mth.cos((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        if (world.isClientSide()) {
            world.addParticle((ParticleOptions)ParticleTypes.POOF, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void effectPlayer(ItemStack itemstack, Player entityplayer, Level world) {
    }

    @Override
    public float getMaxZoom() {
        return 0.1f;
    }
}

