/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.item.neoforge.WMItemImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.Nullable;

public class WMItem
extends Item {
    public static final String CANNON_BALL_ID = "cannonball";
    public static final WMItem CANNON_BALL_ITEM = WMItemBuilder.createWMItem();
    public static final String BLUNDER_SHOT_ID = "shot";
    public static final WMItem BLUNDER_SHOT_ITEM = WMItemBuilder.createWMItem();
    public static final String MUSKET_IRON_PART_ID = "musket-ironpart";
    public static final WMItem MUSKET_IRON_PART_ITEM = WMItemBuilder.createWMItem();
    public static final String BLUNDER_IRON_PART_ID = "blunder-ironpart";
    public static final WMItem BLUNDER_IRON_PART_ITEM = WMItemBuilder.createWMItem();
    public static final String GUN_STOCK_ID = "gun-stock";
    public static final WMItem GUN_STOCK_ITEM = WMItemBuilder.createWMItem();
    public static final String MORTAR_IRON_PART_ID = "mortar-ironpart";
    public static final WMItem MORTAR_IRON_PART_ITEM = WMItemBuilder.createWMItem();

    public WMItem() {
        this(WMItem.getBaseProperties(null));
    }

    public WMItem(Item.Properties properties) {
        super(properties.arch$tab(CreativeModeTabs.COMBAT));
    }

    public static Item.Properties getBaseProperties(@Nullable Tier tier) {
        Item.Properties properties = new Item.Properties();
        if (tier == Tiers.NETHERITE) {
            properties = properties.fireResistant();
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onPlayerDestroyItem(Player player, ItemStack stack, InteractionHand hand) {
        void var2_2;
        void var1_1;
        WMItemImpl.onPlayerDestroyItem(player, (ItemStack)var1_1, (InteractionHand)var2_2);
    }

    public static void decrStackSize(ItemStack stack, int amount, LivingEntity entity) {
        stack.shrink(amount);
        if (stack.isEmpty() && entity instanceof Player) {
            Player player = (Player)entity;
            WMItem.onPlayerDestroyItem(player, stack, player.swingingArm);
        }
    }

    public static boolean isItemInList(ItemStack stack, Collection<Item> items) {
        return stack != null && items.contains(stack.getItem());
    }

    @Nullable
    public static Tuple<InteractionHand, Integer> findAnyItemSlot(Player player, Collection<Item> item) {
        if (WMItem.isItemInList(player.getMainHandItem(), item)) {
            return new Tuple((Object)InteractionHand.MAIN_HAND, (Object)player.getInventory().selected);
        }
        if (WMItem.isItemInList(player.getOffhandItem(), item)) {
            return new Tuple((Object)InteractionHand.OFF_HAND, (Object)0);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = player.getInventory().getItem(i);
            if (!WMItem.isItemInList(itemstack, item)) continue;
            return new Tuple((Object)InteractionHand.MAIN_HAND, (Object)i);
        }
        return null;
    }

    public static boolean consumeInventoryItem(Player player, Item item) {
        return WMItem.consumeAnyInventoryItem(player, Collections.singletonList(item));
    }

    public static boolean consumeAnyInventoryItem(Player player, Collection<Item> item) {
        Tuple<InteractionHand, Integer> slot = WMItem.findAnyItemSlot(player, item);
        if (slot == null) {
            return false;
        }
        NonNullList inv = slot.getA() == InteractionHand.OFF_HAND ? player.getInventory().offhand : player.getInventory().items;
        ((ItemStack)inv.get(((Integer)slot.getB()).intValue())).shrink(1);
        return true;
    }
}

