/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.render.ModelCannonBarrel;
import ckathode.weaponmod.render.ModelCannonLegacy;
import ckathode.weaponmod.render.ModelCannonStandard;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RenderCannon
extends WMRenderer<EntityCannon> {
    private final ModelCannonBarrel modelBarrel;
    private final ModelCannonStandard modelStandard;
    private final ModelCannonLegacy modelLegacy;

    public RenderCannon(EntityRendererProvider.Context context) {
        super(context);
        this.modelBarrel = new ModelCannonBarrel(context.bakeLayer(ModelCannonBarrel.CANNON_BARREL_LAYER));
        this.modelStandard = new ModelCannonStandard(context.bakeLayer(ModelCannonStandard.CANNON_STANDARD_LAYER));
        this.modelLegacy = new ModelCannonLegacy(context.bakeLayer(ModelCannonLegacy.CANNON_LEGACY_LAYER));
        this.shadowRadius = 0.7f;
    }

    public void render(@NotNull EntityCannon entitycannon, float f, float f1, @NotNull PoseStack ms, @NotNull MultiBufferSource bufs, int lm) {
        ms.pushPose();
        f = this.interpolateRotation(entitycannon.yRotO, entitycannon.getYRot(), f1);
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.translate(0.0, 0.1, 0.0);
            ms.mulPose(Axis.YP.rotationDegrees(-f));
        } else {
            ms.translate(0.0f, 2.375f, 0.0f);
            ms.mulPose(Axis.YP.rotationDegrees(180.0f - f));
        }
        float f2 = (float)entitycannon.getHurtTime() - f1;
        float f3 = (float)entitycannon.getCurrentDamage() - f1;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            ms.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)f2) * f2 * f3 / 10.0f * (float)entitycannon.getRockDirection() / 5.0f));
        }
        VertexConsumer builder = bufs.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entitycannon)));
        float f4 = 1.0f;
        if (entitycannon.isSuperPowered() && entitycannon.tickCount % 5 < 2) {
            f4 = 1.5f;
        }
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.scale(-1.0f, -1.0f, 1.0f);
            ms.mulPose(Axis.XP.rotationDegrees(180.0f));
            this.modelLegacy.barrel.xRot = Math.max(-entitycannon.getXRot() / 120.0f, -0.25f);
            this.modelLegacy.renderToBuffer(ms, builder, lm, OverlayTexture.NO_OVERLAY, f4, f4, f4, 1.0f);
        } else {
            float yawRadians;
            float rot = entitycannon.xRotO + (entitycannon.getXRot() - entitycannon.xRotO) * f1;
            rot = Math.min(rot, 20.0f);
            ms.scale(-1.6f, -1.6f, 1.6f);
            ms.pushPose();
            ms.translate(0.0f, 1.0f, 0.0f);
            ms.mulPose(Axis.XP.rotationDegrees(rot));
            ms.translate(0.0f, -1.0f, 0.0f);
            this.modelBarrel.renderToBuffer(ms, builder, lm, OverlayTexture.NO_OVERLAY, f4, f4, f4, 1.0f);
            ms.popPose();
            this.modelStandard.base1.yRot = yawRadians = -((float)Math.toRadians(f));
            this.modelStandard.base2.yRot = yawRadians;
            this.modelStandard.baseStand.yRot = yawRadians;
            this.modelStandard.renderToBuffer(ms, builder, lm, OverlayTexture.NO_OVERLAY, f4, f4, f4, 1.0f);
        }
        ms.popPose();
        super.render((Entity)entitycannon, f, f1, ms, bufs, lm);
    }

    private float interpolateRotation(float from, float to, float by) {
        return (from + Mth.wrapDegrees((float)(to - from)) * by) % 360.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityCannon entity) {
        return WeaponModConfig.get().legacyCannonModel ? WeaponModResources.Entity.CANNON_LEGACY : WeaponModResources.Entity.CANNON;
    }
}

