/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.projectile.EntityJavelin;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RenderJavelin
extends WMRenderer<EntityJavelin> {
    public RenderJavelin(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull EntityJavelin entityjavelin, float f, float f1, @NotNull PoseStack ms, @NotNull MultiBufferSource bufs, int lm) {
        if (!WeaponModConfig.get().itemModelForEntity) {
            VertexConsumer builder = bufs.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entityjavelin)));
            ms.pushPose();
            ms.mulPose(Axis.YP.rotationDegrees(entityjavelin.yRotO + (entityjavelin.getYRot() - entityjavelin.yRotO) * f1 - 90.0f));
            ms.mulPose(Axis.ZP.rotationDegrees(entityjavelin.xRotO + (entityjavelin.getXRot() - entityjavelin.xRotO) * f1));
            float length = 20.0f;
            float f11 = (float)entityjavelin.shakeTime - f1;
            if (f11 > 0.0f) {
                float f12 = -Mth.sin((float)(f11 * 3.0f)) * f11;
                ms.mulPose(Axis.ZP.rotationDegrees(f12));
            }
            ms.mulPose(Axis.XP.rotationDegrees(45.0f));
            ms.scale(0.05625f, 0.05625f, 0.05625f);
            ms.translate(-4.0f, 0.0f, 0.0f);
            PoseStack.Pose last = ms.last();
            this.drawVertex(last, builder, -length, -2.0f, -2.0f, 0.0f, 0.15625f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, -2.0f, 2.0f, 0.15625f, 0.15625f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, 2.0f, 0.15625f, 0.3125f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, -2.0f, 0.0f, 0.3125f, 0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, -2.0f, 0.0f, 0.15625f, -0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, 2.0f, 2.0f, 0.15625f, 0.15625f, -0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, -2.0f, 2.0f, 0.15625f, 0.3125f, -0.05625f, 0.0f, 0.0f, lm);
            this.drawVertex(last, builder, -length, -2.0f, -2.0f, 0.0f, 0.3125f, -0.05625f, 0.0f, 0.0f, lm);
            for (int j = 0; j < 4; ++j) {
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
                last = ms.last();
                this.drawVertex(last, builder, -length, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, length, -2.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, length, 2.0f, 0.0f, 1.0f, 0.15625f, 0.0f, 0.0f, 0.05625f, lm);
                this.drawVertex(last, builder, -length, 2.0f, 0.0f, 0.0f, 0.15625f, 0.0f, 0.0f, 0.05625f, lm);
            }
            ms.popPose();
        } else {
            ItemRenderer itemRender = Minecraft.getInstance().getItemRenderer();
            ms.pushPose();
            ms.scale(1.7f, 1.7f, 1.7f);
            ms.mulPose(Axis.YP.rotationDegrees(entityjavelin.yRotO + (entityjavelin.getYRot() - entityjavelin.yRotO) * f1 - 90.0f));
            ms.mulPose(Axis.ZP.rotationDegrees(entityjavelin.xRotO + (entityjavelin.getXRot() - entityjavelin.xRotO) * f1 - 45.0f));
            float f13 = (float)entityjavelin.shakeTime - f1;
            if (f13 > 0.0f) {
                float f14 = -Mth.sin((float)(f13 * 3.0f)) * f13;
                ms.mulPose(Axis.ZP.rotationDegrees(f14));
            }
            ms.translate(-0.25f, -0.25f, 0.0f);
            ms.mulPose(Axis.YP.rotationDegrees(180.0f));
            itemRender.renderStatic(this.getStackToRender(entityjavelin), ItemDisplayContext.NONE, lm, OverlayTexture.NO_OVERLAY, ms, bufs, entityjavelin.level(), entityjavelin.getId());
            ms.popPose();
        }
        super.render((Entity)entityjavelin, f, f1, ms, bufs, lm);
    }

    public ItemStack getStackToRender(EntityJavelin entity) {
        return new ItemStack((ItemLike)WMRegistries.ITEM_JAVELIN.get());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityJavelin entity) {
        return WeaponModResources.Entity.JAVELIN;
    }
}

