/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.AdvancedExplosion;
import ckathode.weaponmod.network.MsgExplosion;
import ckathode.weaponmod.network.WMMessagePipeline;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public final class PhysHelper {
    private static class_243 kbMotion = class_243.field_1353;
    private static int knockBackModifier = 0;

    public static AdvancedExplosion createStandardExplosion(class_1937 world, class_1297 entity, double d, double d1, double d2, float size, boolean flame, class_1927.class_4179 mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion();
        explosion.doBlockExplosion();
        explosion.doParticleExplosion(true, true);
        PhysHelper.sendExplosion(world, explosion, true, true);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(class_1937 world, class_1297 entity, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles, boolean flame, class_1927.class_4179 mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion(world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(class_1937 world, class_1297 entity, class_1282 damagesource, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles, boolean flame, class_1927.class_4179 mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion(damagesource);
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion(world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(class_1937 world, class_1297 entity, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnParticles, boolean flame, class_1927.class_4179 mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnParticles, spawnParticles);
        PhysHelper.sendExplosion(world, explosion, spawnParticles, spawnParticles);
        return explosion;
    }

    public static void sendExplosion(class_1937 world, AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            if (!world.field_9236) {
                MsgExplosion msg = new MsgExplosion(explosion, smallparts, bigparts);
                WMMessagePipeline.sendToAround(msg, serverLevel, explosion.explosionX, explosion.explosionY, explosion.explosionZ, 64.0, (class_5321<class_1937>)world.method_27983());
            }
        }
    }

    public static void knockBack(class_1309 entityliving, class_1309 attacker, float knockback) {
        entityliving.method_18799(kbMotion);
        double dx = attacker.method_23317() - entityliving.method_23317();
        double dz = attacker.method_23321() - entityliving.method_23321();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        entityliving.field_6271 = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - entityliving.method_36454();
        double f = Math.sqrt(dx * dx + dz * dz);
        class_243 motion = entityliving.method_18798().method_1019(new class_243(-dx / f * (double)knockback, (double)knockback, -dz / f * (double)knockback));
        if (motion.field_1351 > 0.4) {
            motion = new class_243(motion.field_1352, 0.4, motion.field_1350);
        }
        entityliving.method_18799(motion);
        if (knockBackModifier > 0) {
            dx = -Math.sin(Math.toRadians(attacker.method_36454())) * (double)knockBackModifier * 0.5;
            dz = Math.cos(Math.toRadians(attacker.method_36454())) * (double)knockBackModifier * 0.5;
            entityliving.method_5762(dx, 0.1, dz);
        }
        if (entityliving instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entityliving;
            serverPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)entityliving));
        }
        knockBackModifier = 0;
        kbMotion = class_243.field_1353;
    }

    public static void prepareKnockbackOnEntity(class_1309 attacker, class_1309 entity) {
        knockBackModifier = class_1890.method_8205((class_1309)attacker);
        if (attacker.method_5624()) {
            ++knockBackModifier;
        }
        kbMotion = entity.method_18798();
    }
}

