/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import org.jetbrains.annotations.NotNull;

public class EntityBoomerang
extends EntityMaterialProjectile<EntityBoomerang> {
    public static final String ID = "boomerang";
    public static final class_1299<EntityBoomerang> TYPE = WMRegistries.createEntityType("boomerang", new class_4048(0.5f, 0.5f, false), EntityBoomerang::new);
    private static final class_2940<Float> BOOMERANG = class_2945.method_12791(EntityBoomerang.class, (class_2941)class_2943.field_13320);
    public static final double RETURN_STRENGTH = 0.05;
    public static final float MIN_FLOAT_STRENGTH = 0.4f;
    private float soundTimer;
    public float floatStrength;

    public EntityBoomerang(class_1299<EntityBoomerang> entityType, class_1937 world) {
        super(entityType, world);
    }

    public EntityBoomerang(class_1937 world, double x, double y, double z) {
        this(TYPE, world);
        this.method_5814(x, y, z);
    }

    public EntityBoomerang(class_1937 world, class_1309 shooter, class_1799 itemstack) {
        this(world, shooter.method_23317(), shooter.method_23320() - 0.1, shooter.method_23321());
        this.method_7432((class_1297)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
        this.soundTimer = 0.0f;
    }

    @NotNull
    public class_2596<?> method_18002() {
        return NetworkManager.createAddEntityPacket((class_1297)this);
    }

    public void method_24919(class_1297 entity, float f, float f1, float f2, float f3, float f4) {
        float x = -class_3532.method_15374((float)(f1 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
        float y = -class_3532.method_15374((float)(f * ((float)Math.PI / 180)));
        float z = class_3532.method_15362((float)(f1 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
        this.method_7485(x, y, z, f3, f4);
        class_243 entityMotion = entity.method_18798();
        this.method_18799(this.method_18798().method_1031(entityMotion.field_1352, entity.method_24828() ? 0.0 : entityMotion.field_1351, entityMotion.field_1350));
        this.floatStrength = Math.min(1.5f, f3);
        this.field_6011.method_12778(BOOMERANG, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BOOMERANG, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void method_5773() {
        class_1297 shooter;
        super.method_5773();
        this.floatStrength = ((Float)this.field_6011.method_12789(BOOMERANG)).floatValue();
        if (this.inGround) {
            return;
        }
        this.floatStrength *= 0.994f;
        if (this.floatStrength < 0.4f) {
            if (this.method_7443()) {
                this.method_7439(false);
            }
            this.floatStrength = 0.0f;
        }
        float limitedStrength = Math.min(1.0f, this.floatStrength);
        if (!this.beenInGround) {
            this.method_36456(this.method_36454() + 20.0f * this.floatStrength);
        }
        if (!this.beenInGround && (shooter = this.method_24921()) != null && this.floatStrength > 0.0f) {
            class_243 d = this.method_19538().method_1020(shooter.method_19538()).method_1023(0.0, (double)shooter.method_5751(), 0.0).method_1029();
            this.method_18799(this.method_18798().method_1020(d.method_1021(0.05)));
            this.soundTimer += limitedStrength;
            if (this.soundTimer > 3.0f) {
                this.method_5783(class_3417.field_14600, 0.6f, 1.0f / (this.field_5974.nextFloat() * 0.2f + 2.2f - limitedStrength));
                this.soundTimer %= 3.0f;
            }
        }
        this.field_6011.method_12778(BOOMERANG, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    public void method_7454(class_3966 result) {
        class_1792 class_17922;
        class_1297 shooter;
        if (this.field_6002.field_9236 || this.floatStrength < 0.4f) {
            return;
        }
        class_1297 entity = result.method_17782();
        if (entity == (shooter = this.method_24921())) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                class_1799 item = this.method_7445();
                if (item.method_7960()) {
                    return;
                }
                if (player.method_7337() || player.method_31548().method_7394(item)) {
                    this.method_5783(class_3417.field_15197, 0.2f, ((this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.onItemPickup(player);
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            }
            return;
        }
        class_1282 damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        class_1799 thrownItem = this.getWeapon();
        if (thrownItem.method_7960() || !((class_17922 = thrownItem.method_7909()) instanceof IItemWeapon)) {
            return;
        }
        IItemWeapon iiw = (IItemWeapon)class_17922;
        float damage = iiw.getMeleeComponent().getEntityDamage() + 2.0f + this.extraDamage;
        damage += this.getMeleeHitDamage(entity);
        if (this.method_7443()) {
            damage += 2.0f;
        }
        if (entity.method_5643(damagesource, damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            if (thrownItem.method_7919() + 1 >= thrownItem.method_7936()) {
                thrownItem.method_7934(1);
                this.method_5650(class_1297.class_5529.field_26999);
            } else {
                class_3222 sp;
                thrownItem.method_7970(1, this.field_5974, shooter instanceof class_3222 ? (sp = (class_3222)shooter) : null);
                this.method_5750(0.0, 0.0, 0.0);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void method_24920(class_3965 result) {
        class_2338 blockpos = result.method_17777();
        this.xTile = blockpos.method_10263();
        this.yTile = blockpos.method_10264();
        this.zTile = blockpos.method_10260();
        this.inBlockState = this.field_6002.method_8320(blockpos);
        class_243 motion = result.method_17784().method_1020(this.method_19538());
        this.method_18799(motion);
        class_243 newPos = this.method_19538().method_1020(motion.method_1029().method_1021(0.05));
        this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        this.method_18800((double)(-this.field_5974.nextFloat() * 0.5f) * motion.field_1352, this.field_5974.nextFloat() * 0.1f, (double)(-this.field_5974.nextFloat() * 0.5f) * motion.field_1350);
        this.inGround = result.method_17780() == class_2350.field_11036;
        this.method_7439(false);
        this.beenInGround = true;
        this.floatStrength = 0.0f;
        if (this.inBlockState != null) {
            this.inBlockState.method_26178(this.field_6002, blockpos, (class_1297)this);
        }
    }

    @Override
    public void playHitSound() {
        this.method_5783(class_3417.field_15151, 1.0f, 1.0f / (this.field_5974.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround || this.floatStrength < 0.4f;
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupStatus == EntityProjectile.PickupStatus.ALLOWED || this.pickupStatus == EntityProjectile.PickupStatus.OWNER_ONLY ? 0 : 1200;
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return this.beenInGround || this.floatStrength < 0.4f ? 0.05f : 0.0f;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public void method_5694(@NotNull class_1657 entityplayer) {
        if (!this.beenInGround && this.ticksInAir > 5 && !this.field_6002.field_9236 && this.floatStrength >= 0.4f && entityplayer.equals((Object)this.method_24921())) {
            class_1799 item = this.method_7445();
            if (item.method_7960()) {
                return;
            }
            if (entityplayer.method_7337() || entityplayer.method_31548().method_7394(item)) {
                this.method_5783(class_3417.field_15197, 0.2f, ((this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
        }
        super.method_5694(entityplayer);
    }
}

