/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.network.MsgCannonFire;
import ckathode.weaponmod.network.MsgExplosion;
import ckathode.weaponmod.network.WMMessage;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public final class WMMessagePipeline {
    public static final NetworkChannel CHANNEL = NetworkChannel.create((class_2960)new class_2960("weaponmod", "main"));
    private static final LinkedList<Class<? extends WMMessage<?>>> ID_TO_PACKET = new LinkedList();

    public static <T extends WMMessage<T>> void registerPacket(Class<T> messageType) {
        ID_TO_PACKET.add(messageType);
        CHANNEL.register(messageType, WMMessagePipeline::encode, WMMessagePipeline::decode, WMMessagePipeline::handle);
    }

    private static <T extends WMMessage<T>> void encode(T msg, class_2540 buf) {
        if (!ID_TO_PACKET.contains(msg.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + msg.getClass().getCanonicalName());
        }
        int discriminator = ID_TO_PACKET.indexOf(msg.getClass());
        buf.writeInt(discriminator);
        msg.encode((ByteBuf)buf);
    }

    private static <T extends WMMessage<T>> T decode(class_2540 buf) {
        int discriminator;
        Class<WMMessage<?>> clazz;
        ByteBuf payload = buf.duplicate();
        if (payload.readableBytes() < 1) {
            BalkonsWeaponMod.LOGGER.error("Balkon's Weapon Mod has received an empty buffer, likely a result of a LAN server issue.");
        }
        if ((clazz = ID_TO_PACKET.get(discriminator = payload.readInt())) == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        try {
            WMMessage<?> pkt = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pkt.decode(payload.slice());
            return (T)pkt;
        }
        catch (Throwable t) {
            NullPointerException e = new NullPointerException("Could not instantiate packet: " + discriminator);
            e.addSuppressed(t);
            throw e;
        }
    }

    private static <T extends WMMessage<T>> void handle(T msg, Supplier<NetworkManager.PacketContext> ctx) {
        switch (WMUtil.EffectiveSide.get()) {
            case CLIENT: {
                msg.handleClientSide(msg, ctx);
                break;
            }
            case SERVER: {
                msg.handleServerSide(msg, ctx);
            }
        }
    }

    public static <T extends WMMessage<T>> void sendTo(@NotNull WMMessage<T> message, @NotNull class_3222 player) {
        if (CHANNEL.canPlayerReceive(player, message.getClass())) {
            CHANNEL.sendToPlayer(player, message);
        }
    }

    public static <T extends WMMessage<T>> void sendToAround(@NotNull WMMessage<T> message, @NotNull class_3218 level, double x, double y, double z, double radius, class_5321<class_1937> dimension) {
        for (class_3222 player : level.method_8503().method_3760().method_14571()) {
            double f;
            double e;
            double d;
            if (player.field_6002.method_27983() != dimension || !((d = x - player.method_23317()) * d + (e = y - player.method_23318()) * e + (f = z - player.method_23321()) * f < radius * radius)) continue;
            WMMessagePipeline.sendTo(message, player);
        }
    }

    public static <T extends WMMessage<T>> void sendToServer(@NotNull WMMessage<T> message) {
        if (CHANNEL.canServerReceive(message.getClass())) {
            CHANNEL.sendToServer(message);
        }
    }

    public static void init() {
        WMMessagePipeline.registerPacket(MsgCannonFire.class);
        WMMessagePipeline.registerPacket(MsgExplosion.class);
    }
}

