/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.WMItem;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;

public abstract class RangedComponent
extends AbstractWeaponComponent {
    protected static final int MAX_DELAY = 72000;
    public final RangedSpecs rangedSpecs;

    public static boolean isReloaded(class_1799 itemstack) {
        return ReloadHelper.getReloadState(itemstack).isReloaded();
    }

    public static boolean isReadyToFire(class_1799 itemstack) {
        return ReloadHelper.getReloadState(itemstack) == ReloadHelper.ReloadState.STATE_READY;
    }

    public static void setReloadState(class_1799 itemstack, ReloadHelper.ReloadState state) {
        ReloadHelper.setReloadState(itemstack, state);
    }

    public RangedComponent(RangedSpecs rangedspecs) {
        this.rangedSpecs = rangedspecs;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public class_1792.class_1793 setProperties(class_1792.class_1793 properties) {
        return properties.method_7898(this.rangedSpecs.durability);
    }

    @Override
    public float getDamage() {
        return 0.0f;
    }

    @Override
    public float getEntityDamage() {
        return 0.0f;
    }

    @Override
    public float getDestroySpeed(class_1799 itemstack, class_2680 block) {
        return 0.0f;
    }

    @Override
    public boolean canHarvestBlock(class_2680 block) {
        return false;
    }

    @Override
    public boolean mineBlock(class_1799 itemstack, class_1937 world, class_2680 block, class_2338 pos, class_1309 entityliving) {
        return false;
    }

    @Override
    public boolean hurtEnemy(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return false;
    }

    @Override
    public float getAttackDelay(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return 0.0f;
    }

    @Override
    public float getKnockBack(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return 0.0f;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public void addItemAttributeModifiers(Multimap<class_1320, class_1322> multimap) {
        multimap.put((Object)WeaponModAttributes.RELOAD_TIME, (Object)new class_1322(IItemWeapon.RELOAD_TIME_MODIFIER, "Weapon reloadtime modifier", (double)this.rangedSpecs.getReloadTime(), class_1322.class_1323.field_6328));
    }

    @Override
    public boolean onLeftClickEntity(class_1799 itemstack, class_1657 player, class_1297 entity) {
        return false;
    }

    @Override
    public class_1839 getUseAnimation(class_1799 itemstack) {
        ReloadHelper.ReloadState state = ReloadHelper.getReloadState(itemstack);
        if (state == ReloadHelper.ReloadState.STATE_NONE) {
            return class_1839.field_8949;
        }
        if (state == ReloadHelper.ReloadState.STATE_READY) {
            return class_1839.field_8953;
        }
        return class_1839.field_8952;
    }

    @Override
    public int getUseDuration(class_1799 itemstack) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 entityplayer, class_1268 hand) {
        class_1799 itemstack = entityplayer.method_5998(hand);
        if (itemstack.method_7960() || entityplayer.method_6115()) {
            return new class_1271(class_1269.field_5814, (Object)itemstack);
        }
        if (!this.hasAmmo(itemstack, world, entityplayer)) {
            this.soundEmpty(itemstack, world, entityplayer);
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
            return new class_1271(class_1269.field_5814, (Object)itemstack);
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            this.soundCharge(itemstack, world, entityplayer);
            entityplayer.method_6019(hand);
            return new class_1271(class_1269.field_5812, (Object)itemstack);
        }
        entityplayer.method_6019(hand);
        return new class_1271(class_1269.field_5812, (Object)itemstack);
    }

    @Override
    public void onUsingTick(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        class_1657 entityplayer = (class_1657)livingEntity;
        if (ReloadHelper.getReloadState(stack) == ReloadHelper.ReloadState.STATE_NONE && this.getUseDuration(stack) - remainingUseDuration >= this.getReloadDuration(stack)) {
            this.effectReloadDone(stack, entityplayer.field_6002, entityplayer);
            RangedComponent.setReloadState(stack, ReloadHelper.ReloadState.STATE_RELOADED);
        }
    }

    @Override
    public void releaseUsing(class_1799 itemstack, class_1937 world, class_1309 entityliving, int i) {
        class_1657 entityplayer = (class_1657)entityliving;
        if (!RangedComponent.isReloaded(itemstack)) {
            return;
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            if (this.hasAmmoAndConsume(itemstack, world, entityplayer)) {
                this.fire(itemstack, world, (class_1309)entityplayer, i);
            }
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        } else {
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_READY);
        }
    }

    @Override
    public void inventoryTick(class_1799 itemstack, class_1937 world, class_1297 entity, int i, boolean flag) {
    }

    public void soundEmpty(class_1799 itemstack, class_1937 world, class_1657 entityplayer) {
        world.method_8465(null, entityplayer.method_23317(), entityplayer.method_23318(), entityplayer.method_23321(), class_3417.field_14762, class_3419.field_15248, 1.0f, 1.25f);
    }

    public void soundCharge(class_1799 itemstack, class_1937 world, class_1657 entityplayer) {
    }

    public void postShootingEffects(class_1799 itemstack, class_1657 entityplayer, class_1937 world) {
        this.effectPlayer(itemstack, entityplayer, world);
        this.effectShoot(world, entityplayer.method_23317(), entityplayer.method_23318(), entityplayer.method_23321(), entityplayer.field_6031, entityplayer.field_5965);
    }

    public abstract void effectReloadDone(class_1799 var1, class_1937 var2, class_1657 var3);

    public abstract void fire(class_1799 var1, class_1937 var2, class_1309 var3, int var4);

    public abstract void effectPlayer(class_1799 var1, class_1657 var2, class_1937 var3);

    public abstract void effectShoot(class_1937 var1, double var2, double var4, double var6, float var8, float var9);

    public void applyProjectileEnchantments(EntityProjectile<?> entity, class_1799 itemstack) {
        int knockback;
        int damage;
        if (class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)itemstack) > 0) {
            entity.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        }
        if ((damage = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)itemstack)) > 0) {
            entity.setExtraDamage(damage);
        }
        if ((knockback = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)itemstack)) > 0) {
            entity.method_7449(knockback);
        }
        if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)itemstack) > 0) {
            entity.method_5639(100);
        }
    }

    public int getReloadDuration(class_1799 itemstack) {
        return this.rangedSpecs.getReloadTime();
    }

    public List<class_1792> getAmmoItems() {
        return this.rangedSpecs.getAmmoItems();
    }

    protected class_1799 findAmmo(class_1657 entityplayer) {
        class_3545<class_1268, Integer> slot = WMItem.findAnyItemSlot(entityplayer, this.getAmmoItems());
        if (slot == null) {
            return class_1799.field_8037;
        }
        class_2371 inv = slot.method_15442() == class_1268.field_5810 ? entityplayer.field_7514.field_7544 : entityplayer.field_7514.field_7547;
        return (class_1799)inv.get(((Integer)slot.method_15441()).intValue());
    }

    protected boolean consumeAmmo(class_1657 entityplayer) {
        return WMItem.consumeAnyInventoryItem(entityplayer, this.getAmmoItems());
    }

    public boolean hasAmmoAndConsume(class_1799 itemstack, class_1937 world, class_1657 entityplayer) {
        return entityplayer.method_7337() || class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)itemstack) > 0 || this.consumeAmmo(entityplayer);
    }

    public boolean hasAmmo(class_1799 itemstack, class_1937 world, class_1657 entityplayer) {
        boolean flag = !this.findAmmo(entityplayer).method_7960();
        return entityplayer.method_7337() || class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)itemstack) > 0 || flag;
    }

    public float getFOVMultiplier(int ticksinuse) {
        float f1 = (float)ticksinuse / this.getMaxAimTimeTicks();
        f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
        return 1.0f - f1 * this.getMaxZoom();
    }

    protected float getMaxAimTimeTicks() {
        return 20.0f;
    }

    protected float getMaxZoom() {
        return 0.15f;
    }

    public static enum RangedSpecs {
        BLOWGUN("blowgun", 250, (String[])Arrays.stream(DartType.dartTypes).filter(Objects::nonNull).map(t -> new class_2960("weaponmod", t.typeName).toString()).toArray(String[]::new)),
        CROSSBOW("crossbow", 250, new class_2960("weaponmod", "bolt").toString()),
        MUSKET("musket", 80, new class_2960("weaponmod", "bullet").toString()),
        BLUNDERBUSS("blunderbuss", 80, new class_2960("weaponmod", "shot").toString()),
        FLINTLOCK("flintlock", 8, new class_2960("weaponmod", "bullet").toString()),
        MORTAR("mortar", 40, new class_2960("weaponmod", "shell").toString());

        private int reloadTime;
        private List<class_1792> ammoItems;
        private final String[] ammoItemTags;
        public final String reloadTimeTag;
        public final int durability;

        private RangedSpecs(String reloadtimetag, int durability, String ... ammoitemtags) {
            this.ammoItemTags = ammoitemtags;
            this.reloadTimeTag = reloadtimetag;
            this.durability = durability;
            this.ammoItems = null;
            this.reloadTime = -1;
        }

        public int getReloadTime() {
            if (this.reloadTime < 0) {
                this.reloadTime = WeaponModConfig.get().getReloadTime(this.reloadTimeTag);
                BalkonsWeaponMod.LOGGER.debug("Found reload time {} for {} @{}", (Object)this.reloadTime, (Object)this.reloadTimeTag, (Object)this);
            }
            return this.reloadTime;
        }

        public List<class_1792> getAmmoItems() {
            if (this.ammoItems == null) {
                this.ammoItems = Arrays.stream(this.ammoItemTags).map(t -> (class_1792)class_2378.field_11142.method_10223(new class_2960(t))).collect(Collectors.toList());
                BalkonsWeaponMod.LOGGER.debug("Found items {} for {} @{}", this.ammoItems, (Object)Arrays.toString(this.ammoItemTags), (Object)this);
            }
            return this.ammoItems;
        }
    }
}

